package com.destroystokyo.paper.event.entity;

import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/**
 * Called before an entity is spawned into a world by a spawner.
 * <p>
 * This only includes the spawner's location and not the full BlockState snapshot for performance reasons.
 * If you really need it you have to get the spawner yourself.
 */
public class PreSpawnerSpawnEvent extends PreCreatureSpawnEvent {

    @NotNull private final Location spawnerLocation;

    @ApiStatus.Internal
    public PreSpawnerSpawnEvent(@NotNull Location location, @NotNull EntityType type, @NotNull Location spawnerLocation) {
        super(location, type, CreatureSpawnEvent.SpawnReason.SPAWNER);
        this.spawnerLocation = spawnerLocation;
    }

    @NotNull
    public Location getSpawnerLocation() {
        return this.spawnerLocation;
    }
}
