/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import java.util.Date;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OfflinePlayer
extends ServerOperator,
AnimalTamer,
ConfigurationSerializable {
    public boolean isOnline();

    @Override
    @Nullable
    public String getName();

    @Override
    @NotNull
    public UUID getUniqueId();

    @NotNull
    public com.destroystokyo.paper.profile.PlayerProfile getPlayerProfile();

    public boolean isBanned();

    @NotNull
    default public BanEntry banPlayer(@Nullable String reason) {
        return this.banPlayer(reason, null, null);
    }

    @NotNull
    default public BanEntry banPlayer(@Nullable String reason, @Nullable String source) {
        return this.banPlayer(reason, null, source);
    }

    @NotNull
    default public BanEntry banPlayer(@Nullable String reason, @Nullable Date expires) {
        return this.banPlayer(reason, expires, null);
    }

    @NotNull
    default public BanEntry banPlayer(@Nullable String reason, @Nullable Date expires, @Nullable String source) {
        return this.banPlayer(reason, expires, source, true);
    }

    @NotNull
    default public BanEntry banPlayer(@Nullable String reason, @Nullable Date expires, @Nullable String source, boolean kickIfOnline) {
        BanEntry<String> banEntry = Bukkit.getServer().getBanList(BanList.Type.NAME).addBan((String)this.getName(), reason, expires, source);
        if (kickIfOnline && this.isOnline()) {
            this.getPlayer().kickPlayer(reason);
        }
        return banEntry;
    }

    @Nullable
    public BanEntry<PlayerProfile> ban(@Nullable String var1, @Nullable Date var2, @Nullable String var3);

    public boolean isWhitelisted();

    public void setWhitelisted(boolean var1);

    @Nullable
    public Player getPlayer();

    public long getFirstPlayed();

    @Deprecated
    public long getLastPlayed();

    public boolean hasPlayedBefore();

    @Nullable
    public Location getBedSpawnLocation();

    public long getLastLogin();

    public long getLastSeen();

    public void incrementStatistic(@NotNull Statistic var1) throws IllegalArgumentException;

    public void decrementStatistic(@NotNull Statistic var1) throws IllegalArgumentException;

    public void incrementStatistic(@NotNull Statistic var1, int var2) throws IllegalArgumentException;

    public void decrementStatistic(@NotNull Statistic var1, int var2) throws IllegalArgumentException;

    public void setStatistic(@NotNull Statistic var1, int var2) throws IllegalArgumentException;

    public int getStatistic(@NotNull Statistic var1) throws IllegalArgumentException;

    public void incrementStatistic(@NotNull Statistic var1, @NotNull Material var2) throws IllegalArgumentException;

    public void decrementStatistic(@NotNull Statistic var1, @NotNull Material var2) throws IllegalArgumentException;

    public int getStatistic(@NotNull Statistic var1, @NotNull Material var2) throws IllegalArgumentException;

    public void incrementStatistic(@NotNull Statistic var1, @NotNull Material var2, int var3) throws IllegalArgumentException;

    public void decrementStatistic(@NotNull Statistic var1, @NotNull Material var2, int var3) throws IllegalArgumentException;

    public void setStatistic(@NotNull Statistic var1, @NotNull Material var2, int var3) throws IllegalArgumentException;

    public void incrementStatistic(@NotNull Statistic var1, @NotNull EntityType var2) throws IllegalArgumentException;

    public void decrementStatistic(@NotNull Statistic var1, @NotNull EntityType var2) throws IllegalArgumentException;

    public int getStatistic(@NotNull Statistic var1, @NotNull EntityType var2) throws IllegalArgumentException;

    public void incrementStatistic(@NotNull Statistic var1, @NotNull EntityType var2, int var3) throws IllegalArgumentException;

    public void decrementStatistic(@NotNull Statistic var1, @NotNull EntityType var2, int var3);

    public void setStatistic(@NotNull Statistic var1, @NotNull EntityType var2, int var3);

    @Nullable
    public Location getLastDeathLocation();
}

