package io.papermc.paper.event.player;

import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

/**
 * Called when a player begins editing a sign's text.
 * <p>
 * Cancelling this event stops the sign editing menu from opening.
 */
public class PlayerOpenSignEvent extends PlayerEvent implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private boolean cancel = false;
    @NotNull private final Sign sign;
    @NotNull private final Side side;

    public PlayerOpenSignEvent(@NotNull Player editor, @NotNull Sign sign, @NotNull Side side) {
        super(editor);
        this.sign = sign;
        this.side = side;
    }

    /**
     * Gets the sign that was clicked.
     *
     * @return {@link Sign} that was clicked
     */
    @NotNull
    public Sign getSign() {
        return sign;
    }

    /**
     * Gets which side of the sign was clicked.
     *
     * @return {@link Side} that was clicked
     * @see Sign#getSide(Side)
     */
    @NotNull
    public Side getSide() {
        return side;
    }

    @Override
    public boolean isCancelled() {
        return cancel;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancel = cancel;
    }

    @NotNull
    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}
