/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerHandshakeEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    @NotNull
    private final String originalHandshake;
    @NotNull
    private final String originalSocketAddressHostname;
    private boolean cancelled;
    @Nullable
    private String serverHostname;
    @Nullable
    private String socketAddressHostname;
    @Nullable
    private UUID uniqueId;
    @Nullable
    private String propertiesJson;
    private boolean failed;
    private Component failMessage = Component.text((String)"If you wish to use IP forwarding, please enable it in your BungeeCord config as well!", (TextColor)NamedTextColor.YELLOW);

    @Deprecated
    public PlayerHandshakeEvent(@NotNull String originalHandshake, boolean cancelled) {
        this(originalHandshake, "127.0.0.1", cancelled);
    }

    public PlayerHandshakeEvent(@NotNull String originalHandshake, @NotNull String originalSocketAddressHostname, boolean cancelled) {
        super(true);
        this.originalHandshake = originalHandshake;
        this.originalSocketAddressHostname = originalSocketAddressHostname;
        this.cancelled = cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @NotNull
    public String getOriginalHandshake() {
        return this.originalHandshake;
    }

    @NotNull
    public String getOriginalSocketAddressHostname() {
        return this.originalSocketAddressHostname;
    }

    @Nullable
    public String getServerHostname() {
        return this.serverHostname;
    }

    public void setServerHostname(@NotNull String serverHostname) {
        this.serverHostname = serverHostname;
    }

    @Nullable
    public String getSocketAddressHostname() {
        return this.socketAddressHostname;
    }

    public void setSocketAddressHostname(@NotNull String socketAddressHostname) {
        this.socketAddressHostname = socketAddressHostname;
    }

    @Nullable
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(@NotNull UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Nullable
    public String getPropertiesJson() {
        return this.propertiesJson;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public void setPropertiesJson(@NotNull String propertiesJson) {
        this.propertiesJson = propertiesJson;
    }

    @NotNull
    public Component failMessage() {
        return this.failMessage;
    }

    public void failMessage(@NotNull Component failMessage) {
        this.failMessage = failMessage;
    }

    @Deprecated
    @NotNull
    public String getFailMessage() {
        return LegacyComponentSerializer.legacySection().serialize(this.failMessage());
    }

    @Deprecated
    public void setFailMessage(@NotNull String failMessage) {
        Preconditions.checkArgument((failMessage != null && !failMessage.isEmpty() ? 1 : 0) != 0, (Object)"fail message cannot be null or empty");
        this.failMessage((Component)LegacyComponentSerializer.legacySection().deserialize(failMessage));
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

