/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.villager;

import com.destroystokyo.paper.entity.villager.ReputationType;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Reputation {
    @NotNull
    private final Map<ReputationType, Integer> reputation;

    public Reputation() {
        this(new EnumMap<ReputationType, Integer>(ReputationType.class));
    }

    public Reputation(@NotNull Map<ReputationType, Integer> reputation) {
        Preconditions.checkNotNull(reputation, (Object)"reputation cannot be null");
        this.reputation = reputation;
    }

    public int getReputation(@NotNull ReputationType type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"the reputation type cannot be null");
        return this.reputation.getOrDefault((Object)type, 0);
    }

    public void setReputation(@NotNull ReputationType type, int value) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"the reputation type cannot be null");
        this.reputation.put(type, value);
    }

    public boolean hasReputationSet(@NotNull ReputationType type) {
        return this.reputation.containsKey((Object)type);
    }
}

