/*
 * Decompiled with CFR 0.152.
 */
package dev.dejvokep.boostedyaml.updater;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.Block;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.block.implementation.TerminatedBlock;
import dev.dejvokep.boostedyaml.engine.ExtendedConstructor;
import dev.dejvokep.boostedyaml.engine.ExtendedRepresenter;
import dev.dejvokep.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import dev.dejvokep.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import dev.dejvokep.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import dev.dejvokep.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import dev.dejvokep.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import dev.dejvokep.boostedyaml.route.Route;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.updater.MergeRule;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class Merger {
    private static final Merger instance = new Merger();

    public static void merge(@NotNull Section document, @NotNull Section defaults, @NotNull UpdaterSettings settings) {
        instance.iterate(document, defaults, settings);
    }

    private void iterate(Section document, Section defaults, UpdaterSettings settings) {
        HashSet documentKeys = new HashSet(((Map)document.getStoredValue()).keySet());
        for (Map.Entry entry : ((Map)defaults.getStoredValue()).entrySet()) {
            Object key = entry.getKey();
            Route route = Route.from(key);
            documentKeys.remove(key);
            Block documentBlock = document.getOptionalBlock(route).orElse(null);
            Block defaultBlock = (Block)entry.getValue();
            if (documentBlock != null) {
                if (documentBlock.isIgnored()) {
                    documentBlock.setIgnored(false);
                    if (!(documentBlock instanceof Section)) continue;
                    this.resetIgnored((Section)documentBlock);
                    continue;
                }
                boolean isDocumentBlockSection = documentBlock instanceof Section;
                boolean isDefaultBlockSection = defaultBlock instanceof Section;
                if (isDefaultBlockSection && isDocumentBlockSection) {
                    this.iterate((Section)documentBlock, (Section)defaultBlock, settings);
                    continue;
                }
                document.set(route, this.getPreservedValue(settings.getMergeRules(), documentBlock, () -> this.cloneBlock(defaultBlock, document), isDocumentBlockSection, isDefaultBlockSection));
                continue;
            }
            document.set(route, this.cloneBlock(defaultBlock, document));
        }
        if (settings.isKeepAll()) {
            return;
        }
        for (Map.Entry key : documentKeys) {
            Route route = Route.fromSingleKey(key);
            Block block = document.getOptionalBlock(route).orElse(null);
            if (block != null && block.isIgnored()) {
                block.setIgnored(false);
                if (!(block instanceof Section)) continue;
                this.resetIgnored((Section)block);
                continue;
            }
            document.remove(route);
        }
    }

    private void resetIgnored(@NotNull Section section) {
        ((Map)section.getStoredValue()).values().forEach(block -> {
            block.setIgnored(false);
            if (block instanceof Section) {
                this.resetIgnored((Section)block);
            }
        });
    }

    @NotNull
    private Block<?> cloneBlock(@NotNull Block<?> block, @NotNull Section newParent) {
        return block instanceof Section ? this.cloneSection((Section)block, newParent) : this.cloneTerminated((TerminatedBlock)block, newParent);
    }

    @NotNull
    private Section cloneSection(@NotNull Section section, @NotNull Section newParent) {
        if (section.getRoute() == null) {
            throw new IllegalArgumentException("Cannot clone the root!");
        }
        YamlDocument root = section.getRoot();
        GeneralSettings generalSettings = root.getGeneralSettings();
        ExtendedRepresenter representer = new ExtendedRepresenter(generalSettings, root.getDumperSettings().buildEngineSettings());
        ExtendedConstructor constructor = new ExtendedConstructor(root.getLoaderSettings().buildEngineSettings(generalSettings), generalSettings.getSerializer());
        Node represented = representer.represent(section);
        constructor.constructSingleDocument(Optional.of(represented));
        section = new Section(newParent.getRoot(), newParent, section.getRoute(), this.moveComments(represented), (MappingNode)represented, constructor);
        constructor.clear();
        return section;
    }

    @NotNull
    private TerminatedBlock cloneTerminated(@NotNull TerminatedBlock entry, @NotNull Section newParent) {
        YamlDocument root = newParent.getRoot();
        GeneralSettings generalSettings = root.getGeneralSettings();
        ExtendedRepresenter representer = new ExtendedRepresenter(generalSettings, root.getDumperSettings().buildEngineSettings());
        ExtendedConstructor constructor = new ExtendedConstructor(root.getLoaderSettings().buildEngineSettings(generalSettings), generalSettings.getSerializer());
        Node represented = representer.represent(entry.getStoredValue());
        constructor.constructSingleDocument(Optional.of(represented));
        entry = new TerminatedBlock((Block<?>)entry, constructor.getConstructed(represented));
        constructor.clear();
        return entry;
    }

    private Node moveComments(@NotNull Node node) {
        ScalarNode scalarNode = new ScalarNode(Tag.STR, "", ScalarStyle.PLAIN);
        scalarNode.setBlockComments(node.getBlockComments());
        scalarNode.setInLineComments(node.getInLineComments());
        scalarNode.setEndComments(node.getEndComments());
        node.setBlockComments(Collections.emptyList());
        node.setInLineComments(null);
        node.setEndComments(null);
        return scalarNode;
    }

    @NotNull
    private Block<?> getPreservedValue(@NotNull Map<MergeRule, Boolean> rules, @NotNull Block<?> documentBlock, @NotNull Supplier<Block<?>> defaultBlock, boolean documentBlockIsSection, boolean defaultBlockIsSection) {
        return rules.get((Object)MergeRule.getFor(documentBlockIsSection, defaultBlockIsSection)) != false ? documentBlock : defaultBlock.get();
    }
}

