/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.maps.version;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.cerus.maps.api.ClientsideMap;
import dev.cerus.maps.api.Frame;
import dev.cerus.maps.api.version.PacketListener;
import dev.cerus.maps.api.version.VersionAdapter;
import dev.cerus.maps.version.PacketHandler21R2;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class VersionAdapter21R2
implements VersionAdapter {
    private Field netManField;

    public void spawnBarrierParticle(Player player, Location loc) {
        player.spawnParticle(Particle.BLOCK_MARKER, loc, 1, (Object)Material.BARRIER.createBlockData());
    }

    public Object makeMapPacket(boolean ignoreBounds, ClientsideMap map) {
        byte[] data;
        int h;
        int x = ignoreBounds ? 0 : map.getX();
        int y = ignoreBounds ? 0 : map.getY();
        int w = ignoreBounds ? 128 : Math.max(1, map.getWidth());
        int n = h = ignoreBounds ? 128 : Math.max(1, map.getHeight());
        if (ignoreBounds) {
            data = map.getData();
        } else {
            data = new byte[w * h];
            for (int xx = 0; xx < w; ++xx) {
                for (int yy = 0; yy < h; ++yy) {
                    data[xx + yy * w] = map.getData()[x + xx + (y + yy) * 128];
                }
            }
        }
        return new PacketPlayOutMap(new MapId(map.getId()), 0, true, (Collection)map.getMarkers().stream().map(cursor -> new MapIcon((Holder)BuiltInRegistries.ar.c((int)cursor.getType()).get(), cursor.getCompressedX(), cursor.getCompressedY(), cursor.getDirection(), !cursor.hasCaption() ? Optional.empty() : this.parse(cursor.getCaptionString()))).collect(Collectors.toList()), new WorldMap.c(x, y, w, h, data));
    }

    private Optional<IChatBaseComponent> parse(String s) {
        if (s == null) {
            return Optional.empty();
        }
        JsonElement element = JsonParser.parseString((String)s);
        if (element == null) {
            return Optional.empty();
        }
        return ComponentSerialization.a.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).result();
    }

    public Object makeFramePacket(int frameId, boolean visible, ClientsideMap map) {
        ItemStack mapItem = new ItemStack(Material.FILLED_MAP, 1);
        MapMeta mapMeta = (MapMeta)mapItem.getItemMeta();
        mapMeta.setMapId(map.getId());
        mapItem.setItemMeta((ItemMeta)mapMeta);
        List<DataWatcher.c> dwItems = Arrays.asList(new DataWatcher.c(8, DataWatcherRegistry.h, (Object)CraftItemStack.asNMSCopy((ItemStack)mapItem)), new DataWatcher.c(0, DataWatcherRegistry.a, (Object)((byte)(visible ? 0 : 32))));
        return new PacketPlayOutEntityMetadata(frameId, dwItems);
    }

    public Object makeFrameSpawnPacket(Frame frame) {
        int n = frame.getEntityId();
        UUID uUID = UUID.randomUUID();
        double d = frame.getPosX();
        double d2 = frame.getPosY();
        double d3 = frame.getPosZ();
        float f = frame.getFacing() == BlockFace.DOWN ? 90.0f : (frame.getFacing() == BlockFace.UP ? -90.0f : 0.0f);
        float f2 = switch (frame.getFacing()) {
            case BlockFace.NORTH -> -180.0f;
            case BlockFace.EAST -> -90.0f;
            case BlockFace.WEST -> 90.0f;
            default -> 0.0f;
        };
        EntityTypes entityTypes = frame.isGlowing() ? EntityTypes.ag : EntityTypes.at;
        int n2 = switch (frame.getFacing()) {
            case BlockFace.UP -> 1;
            case BlockFace.NORTH -> 2;
            case BlockFace.SOUTH -> 3;
            case BlockFace.WEST -> 4;
            case BlockFace.EAST -> 5;
            default -> 0;
        };
        Vec3D vec3D = new Vec3D(0.0, 0.0, 0.0);
        return new PacketPlayOutSpawnEntity(n, uUID, d, d2, d3, f, f2, entityTypes, n2, vec3D, switch (frame.getFacing()) {
            case BlockFace.NORTH -> -180.0;
            case BlockFace.EAST -> -90.0;
            case BlockFace.WEST -> 90.0;
            default -> 0.0;
        });
    }

    public Object makeFrameDespawnPacket(Frame frame) {
        return new PacketPlayOutEntityDestroy(new int[]{frame.getEntityId()});
    }

    public void sendPacket(Player player, Object packet) {
        ((CraftPlayer)player).getHandle().f.b((Packet)packet);
    }

    public void inject(Player player, PacketListener listener, JavaPlugin plugin) {
        NetworkManager networkManager;
        try {
            networkManager = this.getNetworkManager(((CraftPlayer)player).getHandle().f);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            plugin.getLogger().log(Level.WARNING, "Failed to inject packet handler into player %s".formatted(player.getName()), e);
            return;
        }
        networkManager.n.pipeline().addBefore("packet_handler", "maps_listener", (ChannelHandler)new PacketHandler21R2(player, listener, plugin));
    }

    private NetworkManager getNetworkManager(PlayerConnection b) throws IllegalAccessException, NoSuchFieldException {
        if (this.netManField == null) {
            this.netManField = ServerCommonPacketListenerImpl.class.getDeclaredField("e");
            this.netManField.setAccessible(true);
        }
        return (NetworkManager)this.netManField.get(b);
    }
}

