/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.maps.version;

import dev.cerus.maps.api.ClientsideMap;
import dev.cerus.maps.api.Frame;
import dev.cerus.maps.api.version.PacketListener;
import dev.cerus.maps.api.version.VersionAdapter;
import dev.cerus.maps.util.ReflectionUtil;
import dev.cerus.maps.version.PacketHandler18R2;
import io.netty.channel.ChannelHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class VersionAdapter18R2
implements VersionAdapter {
    public void spawnBarrierParticle(Player player, Location loc) {
        player.spawnParticle(Particle.BLOCK_MARKER, loc, 1, (Object)Material.BARRIER.createBlockData());
    }

    public Object makeMapPacket(boolean ignoreBounds, ClientsideMap map) {
        byte[] data;
        int h;
        int x = ignoreBounds ? 0 : map.getX();
        int y = ignoreBounds ? 0 : map.getY();
        int w = ignoreBounds ? 128 : Math.max(1, map.getWidth());
        int n = h = ignoreBounds ? 128 : Math.max(1, map.getHeight());
        if (ignoreBounds) {
            data = map.getData();
        } else {
            data = new byte[w * h];
            for (int xx = 0; xx < w; ++xx) {
                for (int yy = 0; yy < h; ++yy) {
                    data[xx + yy * w] = map.getData()[x + xx + (y + yy) * 128];
                }
            }
        }
        return new PacketPlayOutMap(map.getId(), 0, true, (Collection)map.getMarkers().stream().map(cursor -> new MapIcon(MapIcon.Type.a((byte)cursor.getType()), cursor.getCompressedX(), cursor.getCompressedY(), cursor.getDirection(), !cursor.hasCaption() ? null : IChatBaseComponent.ChatSerializer.a((String)cursor.getCaptionString()))).collect(Collectors.toList()), new WorldMap.b(x, y, w, h, data));
    }

    public Object makeFramePacket(int frameId, boolean visible, ClientsideMap map) {
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(frameId, new DataWatcher(null), false);
        ItemStack mapItem = new ItemStack(Material.FILLED_MAP, 1);
        MapMeta mapMeta = (MapMeta)mapItem.getItemMeta();
        mapMeta.setMapId(map.getId());
        mapItem.setItemMeta((ItemMeta)mapMeta);
        try {
            DataWatcherObject itemObj = DataWatcherRegistry.g.a(8);
            DataWatcher.Item itemItem = new DataWatcher.Item(itemObj, (Object)CraftItemStack.asNMSCopy((ItemStack)mapItem));
            DataWatcherObject flagsObj = DataWatcherRegistry.a.a(0);
            DataWatcher.Item flagsItem = new DataWatcher.Item(flagsObj, (Object)((byte)(visible ? 0 : 32)));
            ReflectionUtil.set((String)"b", packet.getClass(), (Object)packet, Arrays.asList(itemItem, flagsItem));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return packet;
    }

    public Object makeFrameSpawnPacket(Frame frame) {
        int n = frame.getEntityId();
        UUID uUID = UUID.randomUUID();
        double d = frame.getPosX();
        double d2 = frame.getPosY();
        double d3 = frame.getPosZ();
        float f = frame.getFacing() == BlockFace.DOWN ? 90.0f : (frame.getFacing() == BlockFace.UP ? -90.0f : 0.0f);
        float f2 = switch (frame.getFacing()) {
            case BlockFace.NORTH -> -180.0f;
            case BlockFace.EAST -> -90.0f;
            case BlockFace.WEST -> 90.0f;
            default -> 0.0f;
        };
        EntityTypes entityTypes = frame.isGlowing() ? EntityTypes.H : EntityTypes.R;
        return new PacketPlayOutSpawnEntity(n, uUID, d, d2, d3, f, f2, entityTypes, switch (frame.getFacing()) {
            case BlockFace.UP -> 1;
            case BlockFace.NORTH -> 2;
            case BlockFace.SOUTH -> 3;
            case BlockFace.WEST -> 4;
            case BlockFace.EAST -> 5;
            default -> 0;
        }, new Vec3D(0.0, 0.0, 0.0));
    }

    public Object makeFrameDespawnPacket(Frame frame) {
        return new PacketPlayOutEntityDestroy(new int[]{frame.getEntityId()});
    }

    public void sendPacket(Player player, Object packet) {
        ((CraftPlayer)player).getHandle().b.a((Packet)packet);
    }

    public void inject(Player player, PacketListener listener, JavaPlugin plugin) {
        ((CraftPlayer)player).getHandle().b.a().m.pipeline().addBefore("packet_handler", "maps_listener", (ChannelHandler)new PacketHandler18R2(player, listener, plugin));
    }
}

