/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.maps.version;

import dev.cerus.maps.api.ClientsideMap;
import dev.cerus.maps.api.Frame;
import dev.cerus.maps.api.version.PacketListener;
import dev.cerus.maps.api.version.VersionAdapter;
import dev.cerus.maps.util.ReflectionUtil;
import dev.cerus.maps.version.PacketHandler16R3;
import io.netty.channel.ChannelHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.DataWatcherRegistry;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.MapIcon;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutMap;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class VersionAdapter16R3
implements VersionAdapter {
    public void spawnBarrierParticle(Player player, Location loc) {
        player.spawnParticle(Particle.BARRIER, loc, 1);
    }

    public Object makeMapPacket(boolean ignoreBounds, ClientsideMap map) {
        return new PacketPlayOutMap(map.getId(), 0, true, true, (Collection)map.getMarkers().stream().map(cursor -> new MapIcon(MapIcon.Type.a((byte)cursor.getType()), cursor.getCompressedX(), cursor.getCompressedY(), cursor.getDirection(), !cursor.hasCaption() ? null : IChatBaseComponent.ChatSerializer.a((String)cursor.getCaptionString()))).collect(Collectors.toList()), map.getData(), ignoreBounds ? 0 : map.getX(), ignoreBounds ? 0 : map.getY(), ignoreBounds ? 128 : map.getWidth(), ignoreBounds ? 128 : map.getHeight());
    }

    public Object makeFramePacket(int frameId, boolean visible, ClientsideMap map) {
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(frameId, new DataWatcher(null), false);
        ItemStack mapItem = new ItemStack(Material.FILLED_MAP, 1);
        MapMeta mapMeta = (MapMeta)mapItem.getItemMeta();
        mapMeta.setMapId(map.getId());
        mapItem.setItemMeta((ItemMeta)mapMeta);
        try {
            DataWatcherObject itemObj = DataWatcherRegistry.g.a(7);
            DataWatcher.Item itemItem = new DataWatcher.Item(itemObj, (Object)CraftItemStack.asNMSCopy((ItemStack)mapItem));
            DataWatcherObject flagsObj = DataWatcherRegistry.a.a(0);
            DataWatcher.Item flagsItem = new DataWatcher.Item(flagsObj, (Object)((byte)(visible ? 0 : 32)));
            ReflectionUtil.set((String)"b", packet.getClass(), (Object)packet, Arrays.asList(itemItem, flagsItem));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return packet;
    }

    public Object makeFrameSpawnPacket(Frame frame) {
        int n = frame.getEntityId();
        UUID uUID = UUID.randomUUID();
        double d = frame.getPosX();
        double d2 = frame.getPosY();
        double d3 = frame.getPosZ();
        float f = frame.getFacing() == BlockFace.DOWN ? 90.0f : (frame.getFacing() == BlockFace.UP ? -90.0f : 0.0f);
        return new PacketPlayOutSpawnEntity(n, uUID, d, d2, d3, f, switch (frame.getFacing()) {
            case BlockFace.NORTH -> -180.0f;
            case BlockFace.EAST -> -90.0f;
            case BlockFace.WEST -> 90.0f;
            default -> 0.0f;
        }, EntityTypes.ITEM_FRAME, switch (frame.getFacing()) {
            case BlockFace.UP -> 1;
            case BlockFace.NORTH -> 2;
            case BlockFace.SOUTH -> 3;
            case BlockFace.WEST -> 4;
            case BlockFace.EAST -> 5;
            default -> 0;
        }, new Vec3D(0.0, 0.0, 0.0));
    }

    public Object makeFrameDespawnPacket(Frame frame) {
        return new PacketPlayOutEntityDestroy(new int[]{frame.getEntityId()});
    }

    public void sendPacket(Player player, Object packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packet);
    }

    public void inject(Player player, PacketListener listener, JavaPlugin plugin) {
        ((CraftPlayer)player).getHandle().playerConnection.a().channel.pipeline().addBefore("packet_handler", "maps_listener", (ChannelHandler)new PacketHandler16R3(player, listener, plugin));
    }
}

