/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.trait;

import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitProvider;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CustomTrait
implements Trait {
    @Inject
    private TraitProvider provider;
    private final NamespacedId id;
    @Nullable
    private final String displayName;

    private CustomTrait(NamespacedId id, @Nullable String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public static CustomTraitBuilder builder(NamespacedId id) {
        return new CustomTraitBuilder(id);
    }

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.displayName != null ? this.displayName : this.provider.getDisplayName(this, locale, true);
    }

    @Override
    public String getDisplayName(Locale locale, boolean formatted) {
        return this.displayName != null ? this.displayName : this.provider.getDisplayName(this, locale, formatted);
    }

    @Override
    public String getMenuDisplay(double value, Locale locale) {
        return this.provider.getMenuDisplay(this, value, locale);
    }

    @Override
    public String name() {
        return this.id.getKey().toUpperCase(Locale.ROOT);
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }

    public String toString() {
        return this.id.toString();
    }

    public static class CustomTraitBuilder {
        private final NamespacedId id;
        @Nullable
        private String displayName;

        public CustomTraitBuilder(NamespacedId id) {
            this.id = id;
        }

        public CustomTraitBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public CustomTrait build() {
            return new CustomTrait(this.id, this.displayName);
        }
    }
}

