/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.source;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.BaseContext;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.api.source.SourceValues;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;

public class SourceContext
extends BaseContext {
    private final SourceType sourceType;
    private final String sourceName;

    public SourceContext(AuraSkillsApi api, SourceType sourceType, String sourceName) {
        super(api);
        this.sourceType = sourceType;
        this.sourceName = sourceName;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public SourceValues parseValues(ConfigurationNode source) {
        NamespacedId id = NamespacedId.of("auraskills", this.sourceName);
        double xp = source.node(new Object[]{"xp"}).getDouble(0.0);
        @Nullable String displayName = source.node(new Object[]{"display_name"}).getString();
        @Nullable String unitName = source.node(new Object[]{"unit_name"}).getString();
        return new SourceValues(this.api, this.sourceType, id, xp, displayName, unitName);
    }
}

