/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.source;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.source.SourceType;
import dev.aurelium.auraskills.api.source.SourceValues;
import dev.aurelium.auraskills.api.source.XpSource;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class CustomSource
implements XpSource {
    private final SourceValues values;

    public CustomSource(SourceValues values) {
        this.values = values;
    }

    @Override
    public NamespacedId getId() {
        return this.values.getId();
    }

    @Override
    public SourceType getType() {
        return this.values.getType();
    }

    @Override
    public String getDisplayName(Locale locale) {
        SourceType sourceType = this.getType();
        if (sourceType == null) {
            return this.getId().getKey();
        }
        String messagePath = "sources." + sourceType.toString().toLowerCase(Locale.ROOT) + "." + this.getId().getKey().toLowerCase(Locale.ROOT);
        String msg = this.values.getApi().getMessageManager().getMessage(messagePath, locale);
        if (msg.equals(messagePath) && this.values.getDisplayName() != null) {
            return this.values.getDisplayName();
        }
        return msg;
    }

    @Override
    @Nullable
    public String getUnitName(Locale locale) {
        return this.values.getApi().getSourceManager().getUnitName(this, locale);
    }

    @Override
    public String name() {
        return this.getId().getKey().toUpperCase(Locale.ROOT);
    }

    @Override
    public double getXp() {
        return this.values.getXp();
    }

    public SourceValues getValues() {
        return this.values;
    }
}

