/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.loot;

import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootContextFilter;
import dev.aurelium.auraskills.api.loot.LootOptioned;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;

public class LootPool
extends LootOptioned {
    private final String name;
    private final List<Loot> loot;
    private final double baseChance;
    private final int selectionPriority;
    private final boolean overrideVanillaLoot;
    private final Random random = new Random();

    public LootPool(String name, List<Loot> loot, double baseChance, int selectionPriority, boolean overrideVanillaLoot, Map<String, Object> options) {
        super(options);
        this.name = name;
        this.loot = loot;
        this.baseChance = baseChance;
        this.selectionPriority = selectionPriority;
        this.overrideVanillaLoot = overrideVanillaLoot;
    }

    public String getName() {
        return this.name;
    }

    public List<Loot> getLoot() {
        return this.loot;
    }

    public double getBaseChance() {
        return this.baseChance;
    }

    public int getSelectionPriority() {
        return this.selectionPriority;
    }

    public boolean overridesVanillaLoot() {
        return this.overrideVanillaLoot;
    }

    public Optional<Loot> rollLoot(LootContextFilter filter) {
        List lootList = new ArrayList<Loot>(this.loot).stream().filter(filter::passesFilter).collect(Collectors.toList());
        int totalWeight = 0;
        for (Loot loot : lootList) {
            totalWeight += loot.getValues().getWeight();
        }
        if (totalWeight == 0) {
            return Optional.empty();
        }
        int selected = this.random.nextInt(totalWeight);
        int currentWeight = 0;
        Loot selectedLoot = null;
        for (Loot loot : lootList) {
            if (selected >= currentWeight && selected < currentWeight + loot.getValues().getWeight()) {
                selectedLoot = loot;
                break;
            }
            currentWeight += loot.getValues().getWeight();
        }
        return Optional.ofNullable(selectedLoot);
    }
}

