/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.stat;

import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatProvider;
import dev.aurelium.auraskills.api.trait.Trait;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public enum Stats implements Stat
{
    STRENGTH,
    HEALTH,
    REGENERATION,
    LUCK,
    WISDOM,
    TOUGHNESS,
    CRIT_CHANCE,
    CRIT_DAMAGE,
    SPEED;

    @Inject
    private StatProvider provider;
    private final NamespacedId id = NamespacedId.of("auraskills", this.name().toLowerCase(Locale.ROOT));

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    public List<Trait> getTraits() {
        return this.provider.getTraits(this);
    }

    @Override
    public double getTraitModifier(Trait trait) {
        return this.provider.getTraitModifier(this, trait);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.provider.getDisplayName(this, locale);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.provider.getDescription(this, locale);
    }

    @Override
    public String getColor(Locale locale) {
        return this.provider.getColor(this, locale);
    }

    @Override
    public String getColoredName(Locale locale) {
        return this.provider.getColoredName(this, locale);
    }

    @Override
    public String getSymbol(Locale locale) {
        return this.provider.getSymbol(this, locale);
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }
}

