/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.stat;

import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.item.ItemContext;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatProvider;
import dev.aurelium.auraskills.api.trait.Trait;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CustomStat
implements Stat {
    @Inject
    private StatProvider provider;
    private final NamespacedId id;
    private final Defined defined;

    private CustomStat(NamespacedId id, Defined defined) {
        this.id = id;
        this.defined = defined;
    }

    public static CustomStatBuilder builder(NamespacedId id) {
        return new CustomStatBuilder(id);
    }

    public Defined getDefined() {
        return this.defined;
    }

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    public List<Trait> getTraits() {
        return this.provider.getTraits(this);
    }

    @Override
    public double getTraitModifier(Trait trait) {
        return this.provider.getTraitModifier(this, trait);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.defined.displayName != null ? this.defined.displayName : this.provider.getDisplayName(this, locale);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.defined.description != null ? this.defined.description : this.provider.getDescription(this, locale);
    }

    @Override
    public String getColor(Locale locale) {
        return this.defined.color != null ? this.defined.color : this.provider.getColor(this, locale);
    }

    @Override
    public String getColoredName(Locale locale) {
        return this.provider.getColoredName(this, locale);
    }

    @Override
    public String getSymbol(Locale locale) {
        return this.defined.symbol != null ? this.defined.symbol : this.provider.getSymbol(this, locale);
    }

    @Override
    public String name() {
        return this.id.getKey().toUpperCase(Locale.ROOT);
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }

    public String toString() {
        return this.id.toString();
    }

    public static class Defined {
        private ItemContext item;
        private final Map<Trait, Double> traits = new HashMap<Trait, Double>();
        private String displayName;
        private String description;
        private String color;
        private String symbol;

        private Defined() {
        }

        public ItemContext getItem() {
            return this.item;
        }

        public void setItem(ItemContext item) {
            this.item = item;
        }

        public Map<Trait, Double> getTraits() {
            return this.traits;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }
    }

    public static class CustomStatBuilder {
        private final NamespacedId id;
        private final Defined defined = new Defined();

        private CustomStatBuilder(NamespacedId id) {
            this.id = id;
            this.defined.setItem(ItemContext.builder().material("magenta_stained_glass_pane").group("lower").order(6).build());
        }

        public CustomStatBuilder item(ItemContext item) {
            this.defined.setItem(item);
            return this;
        }

        public CustomStatBuilder displayName(String displayName) {
            this.defined.setDisplayName(displayName);
            return this;
        }

        public CustomStatBuilder description(String description) {
            this.defined.setDescription(description);
            return this;
        }

        public CustomStatBuilder color(String color) {
            this.defined.setColor(color);
            return this;
        }

        public CustomStatBuilder symbol(String symbol) {
            this.defined.setSymbol(symbol);
            return this;
        }

        public CustomStatBuilder trait(Trait trait, double modifier) {
            this.defined.getTraits().put(trait, modifier);
            return this;
        }

        public CustomStat build() {
            return new CustomStat(this.id, this.defined);
        }
    }
}

