/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.ability;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.ability.AbilityProvider;
import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CustomAbility
implements Ability {
    @Inject
    private AbilityProvider provider;
    private final NamespacedId id;
    private final Defined defined;
    private final boolean hasSecondaryValue;

    private CustomAbility(NamespacedId id, Defined defined, boolean hasSecondaryValue) {
        this.id = id;
        this.defined = defined;
        this.hasSecondaryValue = hasSecondaryValue;
    }

    public static CustomAbilityBuilder builder(NamespacedId id) {
        return new CustomAbilityBuilder(id);
    }

    public Defined getDefined() {
        return this.defined;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.defined.displayName != null ? this.defined.displayName : this.provider.getDisplayName(this, locale);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.defined.description != null ? this.defined.description : this.provider.getDescription(this, locale);
    }

    @Override
    public String getInfo(Locale locale) {
        return this.defined.info != null ? this.defined.info : this.provider.getInfo(this, locale);
    }

    @Override
    public String name() {
        return this.id.getKey().toUpperCase(Locale.ROOT);
    }

    @Override
    public boolean hasSecondaryValue() {
        return this.hasSecondaryValue;
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    public double getBaseValue() {
        return this.provider.getBaseValue(this);
    }

    @Override
    public double getSecondaryBaseValue() {
        return this.provider.getSecondaryBaseValue(this);
    }

    @Override
    public double getValue(int level) {
        return this.provider.getValue(this, level);
    }

    @Override
    public double getValuePerLevel() {
        return this.provider.getValuePerLevel(this);
    }

    @Override
    public double getSecondaryValuePerLevel() {
        return this.provider.getSecondaryValuePerLevel(this);
    }

    @Override
    public double getSecondaryValue(int level) {
        return this.provider.getSecondaryValue(this, level);
    }

    @Override
    public Skill getSkill() {
        return this.provider.getSkill(this);
    }

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    @Override
    public int getMaxLevel() {
        return this.provider.getMaxLevel(this);
    }

    @Override
    public int getUnlock() {
        return this.provider.getUnlock(this);
    }

    @Override
    public int getLevelUp() {
        return this.provider.getLevelUp(this);
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }

    public String toString() {
        return this.id.toString();
    }

    public static class Defined {
        private double baseValue = 10.0;
        private double valuePerLevel = 10.0;
        private int unlock = 2;
        private int levelUp = 5;
        private int maxLevel = 0;
        private String displayName;
        private String description;
        private String info;

        private Defined() {
        }

        public double getBaseValue() {
            return this.baseValue;
        }

        public void setBaseValue(double baseValue) {
            this.baseValue = baseValue;
        }

        public double getValuePerLevel() {
            return this.valuePerLevel;
        }

        public void setValuePerLevel(double valuePerLevel) {
            this.valuePerLevel = valuePerLevel;
        }

        public int getUnlock() {
            return this.unlock;
        }

        public void setUnlock(int unlock) {
            this.unlock = unlock;
        }

        public int getLevelUp() {
            return this.levelUp;
        }

        public void setLevelUp(int levelUp) {
            this.levelUp = levelUp;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public void setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getInfo() {
            return this.info;
        }

        public void setInfo(String info) {
            this.info = info;
        }
    }

    public static class CustomAbilityBuilder {
        private final NamespacedId id;
        private final Defined defined = new Defined();
        private boolean hasSecondaryValue;

        public CustomAbilityBuilder(NamespacedId id) {
            this.id = id;
        }

        public CustomAbilityBuilder baseValue(double baseValue) {
            this.defined.setBaseValue(baseValue);
            return this;
        }

        public CustomAbilityBuilder valuePerLevel(double valuePerLevel) {
            this.defined.setValuePerLevel(valuePerLevel);
            return this;
        }

        public CustomAbilityBuilder unlock(int unlock) {
            this.defined.setUnlock(unlock);
            return this;
        }

        public CustomAbilityBuilder levelUp(int levelUp) {
            this.defined.setLevelUp(levelUp);
            return this;
        }

        public CustomAbilityBuilder maxLevel(int maxLevel) {
            this.defined.setMaxLevel(maxLevel);
            return this;
        }

        public CustomAbilityBuilder hasSecondaryValue(boolean hasSecondaryValue) {
            this.hasSecondaryValue = hasSecondaryValue;
            return this;
        }

        public CustomAbilityBuilder displayName(String displayName) {
            this.defined.setDisplayName(displayName);
            return this;
        }

        public CustomAbilityBuilder description(String description) {
            this.defined.setDescription(description);
            return this;
        }

        public CustomAbilityBuilder info(String info) {
            this.defined.setInfo(info);
            return this;
        }

        public CustomAbility build() {
            return new CustomAbility(this.id, this.defined, this.hasSecondaryValue);
        }
    }
}

