/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.util;

import dev.alangomes.springspigot.util.scheduler.SchedulerService;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.bukkit.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Scope(value="singleton")
class UtilAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtilAspect.class);
    @Autowired
    private SchedulerService schedulerService;
    @Autowired
    private Server server;

    UtilAspect() {
    }

    @Order(value=0)
    @Around(value="within(@(@dev.alangomes.springspigot.util.Synchronize *) *) || execution(@(@dev.alangomes.springspigot.util.Synchronize *) * *(..)) || @within(dev.alangomes.springspigot.util.Synchronize)|| execution(@dev.alangomes.springspigot.util.Synchronize * *(..))")
    public Object synchronizeCall(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.server.isPrimaryThread()) {
            return joinPoint.proceed();
        }
        this.schedulerService.scheduleSyncDelayedTask(() -> {
            try {
                joinPoint.proceed();
            }
            catch (Throwable throwable) {
                log.error("Error in synchronous task", throwable);
            }
        }, 0L);
        return null;
    }
}

