/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.util;

import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;
import picocli.CommandLine;

public class CommandUtils {
    private CommandUtils() {
    }

    public static Stream<String> getPossibleSubcommands(CommandLine.Model.CommandSpec commandSpec, String[] args) {
        return CommandUtils.getPossibleSubcommands(commandSpec, args, 0);
    }

    public static Stream<String> getPossibleArguments(CommandLine.Model.CommandSpec commandSpec, String[] args) {
        int requestedIndex = args.length - 1;
        return CommandUtils.getPossibleCommands(commandSpec, args, 0).map(specPair -> ((CommandLine.Model.CommandSpec)specPair.getKey()).positionalParameters().stream().filter(paramSpec -> paramSpec.index().contains(Math.max(0, requestedIndex - ((Integer)specPair.getValue() + 1)))).findFirst()).filter(Optional::isPresent).map(Optional::get).flatMap(CommandUtils::getSuggestedValues).filter(value -> StringUtil.startsWithIgnoreCase((String)value, (String)args[requestedIndex]));
    }

    private static Stream<String> getSuggestedValues(CommandLine.Model.PositionalParamSpec paramSpec) {
        Iterable completionCandidates = paramSpec.completionCandidates();
        if (completionCandidates != null) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(completionCandidates.iterator(), 0), false);
        }
        return CommandUtils.getSuggestedValues(paramSpec.type());
    }

    private static Stream<String> getSuggestedValues(Class<?> type) {
        if (CommandSender.class.isAssignableFrom(type)) {
            return Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName);
        }
        if (World.class.isAssignableFrom(type)) {
            return Bukkit.getWorlds().stream().map(World::getName);
        }
        return Stream.empty();
    }

    private static Stream<String> getPossibleSubcommands(CommandLine.Model.CommandSpec spec, String[] args, int index) {
        if (args.length == 0) {
            return Stream.empty();
        }
        Stream subcommandsStream = spec.subcommands().entrySet().stream();
        if (index + 1 == args.length) {
            return subcommandsStream.filter(entry -> StringUtil.startsWithIgnoreCase((String)((String)entry.getKey()), (String)args[index])).flatMap(entry -> ((CommandLine)entry.getValue()).getCommandSpec().names().stream());
        }
        return subcommandsStream.filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(args[index])).flatMap(entry -> CommandUtils.getPossibleSubcommands(((CommandLine)entry.getValue()).getCommandSpec(), args, index + 1));
    }

    private static Stream<Pair<CommandLine.Model.CommandSpec, Integer>> getPossibleCommands(CommandLine.Model.CommandSpec spec, String[] args, int index) {
        if (args.length <= 1) {
            return Stream.of(Pair.of((Object)spec, (Object)index));
        }
        return spec.subcommands().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(args[index])).flatMap(entry -> {
            if (index + 2 >= args.length || !CommandUtils.hasSubcommand(((CommandLine)entry.getValue()).getCommandSpec(), args[index + 1])) {
                return Stream.of(Pair.of((Object)((CommandLine)entry.getValue()).getCommandSpec(), (Object)index));
            }
            return CommandUtils.getPossibleCommands(((CommandLine)entry.getValue()).getCommandSpec(), args, index + 1);
        });
    }

    private static boolean hasSubcommand(CommandLine.Model.CommandSpec spec, String subcommand) {
        return spec.subcommands().keySet().stream().anyMatch(sub -> sub.equalsIgnoreCase(subcommand));
    }
}

