/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.picocli;

import dev.alangomes.springspigot.picocli.conversion.PicocliConversorInjector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import picocli.CommandLine;

public class CommandLineDefinition {
    private final String beanName;
    private final Object instance;
    private final CommandLine.IFactory commandFactory;
    private final HashMap<String, CommandLineDefinition> subcommands = new HashMap();

    CommandLineDefinition(Object instance, CommandLine.IFactory factory) {
        this.beanName = instance instanceof String ? (String)instance : null;
        this.instance = !(instance instanceof String) ? instance : null;
        this.commandFactory = factory;
    }

    void addSubcommand(String name, Object commandLine) {
        if (commandLine instanceof CommandLineDefinition) {
            this.subcommands.put(name, (CommandLineDefinition)commandLine);
        } else {
            this.subcommands.put(name, new CommandLineDefinition(commandLine, this.commandFactory));
        }
    }

    public CommandLine build(BeanFactory factory) {
        CommandLine commandLine = this.doBuild(factory);
        this.overrideHelpRenderers(commandLine);
        this.overrideConverters(factory, commandLine);
        return commandLine;
    }

    private CommandLine doBuild(BeanFactory factory) {
        CommandLine commandLine = new CommandLine(this.beanName != null ? this.getBean(factory, this.beanName) : this.instance, this.commandFactory);
        this.subcommands.forEach((key, value) -> commandLine.addSubcommand(key, (Object)value.doBuild(factory)));
        return commandLine;
    }

    private Object getBean(BeanFactory factory, String name) {
        Object bean = factory.getBean(name);
        if (AopUtils.isAopProxy((Object)bean)) {
            return ((Advised)bean).getTargetSource().getTarget();
        }
        return bean;
    }

    public Set<String> getCommandNames() {
        return Collections.unmodifiableSet(this.subcommands.keySet());
    }

    private void overrideConverters(BeanFactory beanFactory, CommandLine commandLine) {
        PicocliConversorInjector picocliConversorInjector = (PicocliConversorInjector)beanFactory.getBean(PicocliConversorInjector.class);
        picocliConversorInjector.injectConversor(commandLine);
    }

    private void overrideHelpRenderers(CommandLine commandLine) {
        Map renderers = commandLine.getHelpSectionMap().keySet().stream().collect(Collectors.toMap(Function.identity(), k -> this.overrideRenderer((CommandLine.IHelpSectionRenderer)commandLine.getHelpSectionMap().get(k))));
        commandLine.setHelpSectionMap(renderers);
    }

    private CommandLine.IHelpSectionRenderer overrideRenderer(CommandLine.IHelpSectionRenderer renderer) {
        return h -> renderer.render(h).replaceAll("\\r", "");
    }

    @Generated
    public String getBeanName() {
        return this.beanName;
    }

    @Generated
    public Object getInstance() {
        return this.instance;
    }

    @Generated
    public CommandLine.IFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Generated
    public HashMap<String, CommandLineDefinition> getSubcommands() {
        return this.subcommands;
    }
}

