/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.event;

import dev.alangomes.springspigot.event.SpringEventExecutor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class EventService {
    @Autowired
    private SpringEventExecutor eventExecutor;
    @Autowired
    private Server server;
    @Autowired
    private Plugin plugin;

    public void registerEvents(Listener listener) {
        this.getListenerMethods(listener).forEach(method -> this.registerEvents(listener, (Method)method));
    }

    private void registerEvents(Listener listener, Method method) {
        EventHandler handler = method.getAnnotation(EventHandler.class);
        Class<?> eventType = method.getParameters()[0].getType();
        this.server.getPluginManager().registerEvent(eventType, listener, handler.priority(), this.eventExecutor.create(method), this.plugin, handler.ignoreCancelled());
    }

    private Stream<Method> getListenerMethods(Listener listener) {
        Class target = AopUtils.getTargetClass((Object)listener);
        return Arrays.stream(ReflectionUtils.getAllDeclaredMethods((Class)target)).filter(method -> method.isAnnotationPresent(EventHandler.class)).filter(method -> method.getParameters().length == 1).filter(method -> Event.class.isAssignableFrom(method.getParameters()[0].getType()));
    }
}

