/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.command;

import dev.alangomes.springspigot.command.CommandExecutor;
import dev.alangomes.springspigot.command.CommandResult;
import dev.alangomes.springspigot.context.Context;
import dev.alangomes.springspigot.util.CommandUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import picocli.CommandLine;

class WrappedCommand
extends Command {
    private final Context context;
    private final CommandExecutor commandExecutor;
    private final CommandLine.Model.CommandSpec commandSpec;

    protected WrappedCommand(CommandLine.Model.CommandSpec commandSpec, Context context, CommandExecutor commandExecutor) {
        super(commandSpec.name());
        this.commandSpec = commandSpec;
        this.context = context;
        this.commandExecutor = commandExecutor;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        return this.context.runWithSender(sender, () -> {
            String[] command = WrappedCommand.prepend(args, label);
            CommandResult result = this.commandExecutor.execute(command);
            result.getOutput().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
            return result.isExists();
        });
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        return this.context.runWithSender(sender, () -> {
            Stream<String> possibleSubcommands = CommandUtils.getPossibleSubcommands(this.commandSpec, args);
            Stream<String> possibleArguments = CommandUtils.getPossibleArguments(this.commandSpec, args);
            return Stream.concat(possibleSubcommands, possibleArguments).collect(Collectors.toList());
        });
    }

    public List<String> getAliases() {
        return Arrays.asList(this.commandSpec.aliases());
    }

    public String getUsage() {
        return this.commandSpec.commandLine().getUsageMessage();
    }

    public String getDescription() {
        return String.join((CharSequence)"\n", this.commandSpec.usageMessage().description());
    }

    private static <T> T[] prepend(T[] oldArray, T item) {
        Object[] newArray = (Object[])Array.newInstance(oldArray.getClass().getComponentType(), oldArray.length + 1);
        System.arraycopy(oldArray, 0, newArray, 1, oldArray.length);
        newArray[0] = item;
        return newArray;
    }
}

