/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.command;

import com.google.common.annotations.VisibleForTesting;
import dev.alangomes.springspigot.command.CommandExecutor;
import dev.alangomes.springspigot.command.CommandResult;
import dev.alangomes.springspigot.configuration.DynamicValue;
import dev.alangomes.springspigot.configuration.Instance;
import dev.alangomes.springspigot.picocli.CommandLineDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@Primary
@Component
@ConditionalOnBean(annotation={CommandLine.Command.class})
public class DefaultCommandExecutor
implements CommandExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCommandExecutor.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private AbstractAutoProxyCreator proxyCreator;
    @Autowired
    private CommandLineDefinition cli;
    @DynamicValue(value="${spigot.messages.command_error:&cAn internal error occurred while attemping to perform this command}")
    private Instance<String> commandErrorMessage;
    @DynamicValue(value="${spigot.messages.missing_parameter_error:&cMissing parameter: %s}")
    private Instance<String> missingParameterErrorMessage;
    @DynamicValue(value="${spigot.messages.parameter_error:&cInvalid parameter: %s}")
    private Instance<String> parameterErrorMessage;
    @DynamicValue(value="${spigot.commands.enable_cache:false}")
    private Instance<Boolean> cacheEnabled;
    private CommandLine commandLineCache;

    @Override
    public CommandResult execute(String ... commandParts) {
        if (commandParts.length == 0) {
            return CommandResult.unknown();
        }
        try {
            Object command;
            if (!BooleanUtils.toBoolean((Boolean)this.cacheEnabled.get()) || this.commandLineCache == null) {
                this.commandLineCache = this.cli.build((BeanFactory)this.applicationContext);
            }
            ArrayList<String> output = new ArrayList<String>();
            List commands = this.commandLineCache.parse(commandParts);
            if (commands.isEmpty()) {
                return CommandResult.unknown();
            }
            CommandLine commandLine = (CommandLine)commands.get(commands.size() - 1);
            Object object = command = this.proxyCreator != null ? this.proxyCreator.getEarlyBeanReference(commandLine.getCommand(), null) : commandLine.getCommand();
            if (command instanceof Runnable) {
                ((Runnable)command).run();
            } else if (command instanceof Callable) {
                Object result = ((Callable)command).call();
                output.addAll(this.buildOutput(result));
            }
            return new CommandResult(output);
        }
        catch (CommandLine.InitializationException ex) {
            log.error("Unexpected exception during command initialization", (Throwable)ex);
            return CommandResult.unknown();
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Object commandObject = ex.getCommandLine().getCommandSpec().userObject();
            if (commandObject == null || this.getBaseCommandClass().isInstance(commandObject)) {
                return CommandResult.unknown();
            }
            String message = String.format(this.parameterErrorMessage.get(), String.join((CharSequence)", ", ex.getUnmatched()));
            return new CommandResult(ChatColor.translateAlternateColorCodes((char)'&', (String)message), true);
        }
        catch (CommandLine.MissingParameterException ex) {
            String message = String.format(this.missingParameterErrorMessage.get(), ((CommandLine.Model.ArgSpec)ex.getMissing().get(0)).paramLabel());
            return new CommandResult(ChatColor.translateAlternateColorCodes((char)'&', (String)message), true);
        }
        catch (CommandLine.ParameterException ex) {
            String message = String.format(this.parameterErrorMessage.get(), ex.getArgSpec().paramLabel());
            return new CommandResult(ChatColor.translateAlternateColorCodes((char)'&', (String)message), true);
        }
        catch (CommandException ex) {
            return new CommandResult(ChatColor.RED + ex.getMessage(), true);
        }
        catch (Exception ex) {
            log.error("Unexpected exception while running /" + StringUtils.join((Object[])commandParts, (String)" "), (Throwable)ex);
            return new CommandResult(ChatColor.translateAlternateColorCodes((char)'&', (String)this.commandErrorMessage.get()), true);
        }
    }

    private List<String> buildOutput(Object result) {
        if (result instanceof String) {
            return Collections.singletonList(ChatColor.translateAlternateColorCodes((char)'&', (String)((String)result)));
        }
        if (result instanceof Collection) {
            return ((Collection)result).stream().flatMap(res -> this.buildOutput(res).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Class<?> getBaseCommandClass() {
        return Class.forName("dev.alangomes.springspigot.picocli.BaseCommand");
    }

    @VisibleForTesting
    @Generated
    void setCommandErrorMessage(Instance<String> commandErrorMessage) {
        this.commandErrorMessage = commandErrorMessage;
    }

    @VisibleForTesting
    @Generated
    void setMissingParameterErrorMessage(Instance<String> missingParameterErrorMessage) {
        this.missingParameterErrorMessage = missingParameterErrorMessage;
    }

    @VisibleForTesting
    @Generated
    void setParameterErrorMessage(Instance<String> parameterErrorMessage) {
        this.parameterErrorMessage = parameterErrorMessage;
    }

    @VisibleForTesting
    @Generated
    Instance<Boolean> getCacheEnabled() {
        return this.cacheEnabled;
    }

    @VisibleForTesting
    @Generated
    void setCacheEnabled(Instance<Boolean> cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }
}

