/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.command;

import dev.alangomes.springspigot.command.CommandExecutor;
import dev.alangomes.springspigot.command.WrappedCommand;
import dev.alangomes.springspigot.context.Context;
import dev.alangomes.springspigot.picocli.CommandLineDefinition;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@Component
@Scope(value="singleton")
@ConditionalOnBean(annotation={CommandLine.Command.class})
class CommandService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandService.class);
    private static final String DEFAULT_COMMAND_NAME = "<main class>";
    @Autowired
    private CommandLineDefinition commandLineDefinition;
    @Autowired
    private Context context;
    @Autowired
    private Plugin plugin;
    @Autowired
    private CommandExecutor commandExecutor;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    private boolean registered;
    private Class<?> bukkitClass;

    CommandService() {
    }

    @PostConstruct
    void init() {
        try {
            List<CommandLine.Model.CommandSpec> commandSpecs = this.getCommands();
            String packageName = this.plugin.getServer().getClass().getPackage().getName();
            String version = packageName.substring(packageName.lastIndexOf(46) + 1);
            this.bukkitClass = Class.forName("org.bukkit.craftbukkit." + version + ".CraftServer", false, this.resourceLoader.getClassLoader());
            commandSpecs.forEach(this::registerCommand);
            log.debug("Succesfully registered {} commands", (Object)commandSpecs.size());
            this.registered = true;
        }
        catch (Throwable t) {
            log.debug("Failed to register commands natively, falling back to event listeners", t);
        }
    }

    @PreDestroy
    void destroy() {
        try {
            List<CommandLine.Model.CommandSpec> commandSpecs = this.getCommands();
            commandSpecs.forEach(this::unregisterCommand);
        }
        catch (Throwable t) {
            log.debug("Failed to unregister commands natively", t);
        }
    }

    public void registerCommand(CommandLine.Model.CommandSpec commandSpec) {
        Field commandMapField = this.bukkitClass.getDeclaredField("commandMap");
        commandMapField.setAccessible(true);
        SimpleCommandMap commandMap = (SimpleCommandMap)commandMapField.get(this.plugin.getServer());
        commandMap.register(this.plugin.getName().toLowerCase(), (Command)new WrappedCommand(commandSpec, this.context, this.commandExecutor));
    }

    public void unregisterCommand(CommandLine.Model.CommandSpec commandSpec) {
        String commandName = commandSpec.name();
        SimplePluginManager manager = (SimplePluginManager)this.plugin.getServer().getPluginManager();
        Field commandMapField = SimplePluginManager.class.getDeclaredField("commandMap");
        commandMapField.setAccessible(true);
        CommandMap map = (CommandMap)commandMapField.get(manager);
        Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
        knownCommandsField.setAccessible(true);
        Map knownCommands = (Map)knownCommandsField.get(map);
        Command command = (Command)knownCommands.get(commandName);
        if (command != null) {
            command.unregister(map);
            knownCommands.remove(commandName);
        }
    }

    public List<CommandLine.Model.CommandSpec> getCommands() {
        CommandLine commandLine = this.commandLineDefinition.build((BeanFactory)this.applicationContext);
        CommandLine.Model.CommandSpec commandSpec = commandLine.getCommandSpec();
        if (DEFAULT_COMMAND_NAME.equals(commandSpec.name())) {
            return commandSpec.subcommands().values().stream().map(CommandLine::getCommandSpec).filter(CommandService.distinctByKey(CommandLine.Model.CommandSpec::name)).collect(Collectors.toList());
        }
        return Collections.singletonList(commandSpec);
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    @Generated
    public boolean isRegistered() {
        return this.registered;
    }
}

