/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.command;

import dev.alangomes.springspigot.command.CommandExecutor;
import dev.alangomes.springspigot.command.CommandResult;
import dev.alangomes.springspigot.command.CommandService;
import dev.alangomes.springspigot.context.Context;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@Component
@ConditionalOnBean(annotation={CommandLine.Command.class})
class CommandInterceptor
implements Listener {
    @Autowired
    private Context context;
    @Autowired
    private CommandExecutor commandExecutor;
    @Autowired
    private CommandService commandService;

    CommandInterceptor() {
    }

    @EventHandler
    void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled() || this.commandService.isRegistered()) {
            return;
        }
        Player player = this.context.getPlayer();
        CommandResult result = this.commandExecutor.execute(event.getMessage().substring(1).split(" "));
        event.setCancelled(result.isExists());
        result.getOutput().forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
    }

    @EventHandler
    void onServerCommand(ServerCommandEvent event) {
        if (event.isCancelled() || this.commandService.isRegistered()) {
            return;
        }
        CommandSender sender = this.context.getSender();
        CommandResult result = this.commandExecutor.execute(event.getCommand().split(" "));
        event.setCancelled(result.isExists());
        result.getOutput().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
    }
}

