/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot;

import dev.alangomes.springspigot.SpringSpigotInitializer;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.switchyard.common.type.CompoundClassLoader;

public final class SpringSpigotBootstrapper {
    private SpringSpigotBootstrapper() {
    }

    public static ConfigurableApplicationContext initialize(JavaPlugin plugin, Class<?> applicationClass) throws ExecutionException, InterruptedException {
        CompoundClassLoader classLoader = new CompoundClassLoader(new ClassLoader[]{plugin.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader()});
        return SpringSpigotBootstrapper.initialize(plugin, (ClassLoader)classLoader, new SpringApplicationBuilder(new Class[]{applicationClass}));
    }

    public static ConfigurableApplicationContext initialize(JavaPlugin plugin, SpringApplicationBuilder builder) throws ExecutionException, InterruptedException {
        CompoundClassLoader classLoader = new CompoundClassLoader(new ClassLoader[]{plugin.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader()});
        return SpringSpigotBootstrapper.initialize(plugin, (ClassLoader)classLoader, builder);
    }

    public static ConfigurableApplicationContext initialize(JavaPlugin plugin, ClassLoader classLoader, Class<?> applicationClass) throws ExecutionException, InterruptedException {
        return SpringSpigotBootstrapper.initialize(plugin, classLoader, new SpringApplicationBuilder(new Class[]{applicationClass}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurableApplicationContext initialize(JavaPlugin plugin, ClassLoader classLoader, SpringApplicationBuilder builder) throws ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<ConfigurableApplicationContext> contextFuture = executor.submit(() -> {
                Thread.currentThread().setContextClassLoader(classLoader);
                Properties props = new Properties();
                try {
                    props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("application.properties"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (builder.application().getResourceLoader() == null) {
                    DefaultResourceLoader loader = new DefaultResourceLoader(classLoader);
                    builder.resourceLoader((ResourceLoader)loader);
                }
                return builder.properties(props).initializers(new ApplicationContextInitializer[]{new SpringSpigotInitializer((Plugin)plugin)}).run(new String[0]);
            });
            ConfigurableApplicationContext configurableApplicationContext = contextFuture.get();
            return configurableApplicationContext;
        }
        finally {
            executor.shutdown();
        }
    }
}

