/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.io;

import de.undercouch.bson4jackson.io.StaticBuffers;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class LittleEndianInputStream
extends FilterInputStream
implements DataInput {
    protected static final StaticBuffers.Key UTF8_BUFFER = StaticBuffers.Key.BUFFER0;
    protected byte[] _rawBuf = new byte[8];
    protected ByteBuffer _buf = ByteBuffer.wrap(this._rawBuf).order(ByteOrder.LITTLE_ENDIAN);
    protected CharBuffer _lineBuffer;
    private CharsetDecoder utf8decoder;

    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    private CharsetDecoder getUTF8Decoder() {
        if (this.utf8decoder == null) {
            this.utf8decoder = StandardCharsets.UTF_8.newDecoder();
        }
        return this.utf8decoder;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int r = this.read(b, off, len);
            if (r < 0) {
                throw new EOFException();
            }
            len -= r;
            off += r;
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long s;
        int r = 0;
        while (n > 0 && (s = this.skip(n)) > 0L) {
            r = (int)((long)r + s);
            n = (int)((long)n - s);
        }
        return r;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int r = this.read();
        if (r < 0) {
            throw new EOFException();
        }
        return r;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int r1 = this.readUnsignedByte();
        int r2 = this.readUnsignedByte();
        return r1 + (r2 << 8);
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this._rawBuf, 0, 4);
        return this._buf.getInt(0);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this._rawBuf, 0, 8);
        return this._buf.getLong(0);
    }

    @Override
    public float readFloat() throws IOException {
        this.readFully(this._rawBuf, 0, 4);
        return this._buf.getFloat(0);
    }

    @Override
    public double readDouble() throws IOException {
        this.readFully(this._rawBuf, 0, 8);
        return this._buf.getDouble(0);
    }

    @Override
    public String readLine() throws IOException {
        int c;
        int bufSize = 0;
        if (this._lineBuffer != null) {
            this._lineBuffer.rewind();
            this._lineBuffer.limit(this._lineBuffer.capacity());
            bufSize = this._lineBuffer.capacity();
        }
        while ((c = this.read()) >= 0 && c != 10) {
            if (c == 13) {
                int c2 = this.read();
                if (c2 == -1 || c2 == 10) break;
                if (!(this.in instanceof PushbackInputStream)) {
                    this.in = new PushbackInputStream(this.in);
                }
                ((PushbackInputStream)this.in).unread(c2);
                break;
            }
            if (this._lineBuffer == null || this._lineBuffer.remaining() == 0) {
                int newBufSize = bufSize + 128;
                CharBuffer newBuf = CharBuffer.allocate(newBufSize);
                if (this._lineBuffer != null) {
                    this._lineBuffer.flip();
                    newBuf.put(this._lineBuffer);
                }
                this._lineBuffer = newBuf;
                bufSize = newBufSize;
            }
            this._lineBuffer.put((char)c);
        }
        if (c < 0 && (this._lineBuffer == null || this._lineBuffer.position() == 0)) {
            return null;
        }
        return String.valueOf(this._lineBuffer.array(), 0, this._lineBuffer.position());
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readUTF(int len) throws IOException {
        return this.readUTF(this, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readUTF(DataInput input, int len) throws IOException {
        StaticBuffers staticBuffers = StaticBuffers.getInstance();
        ByteBuffer utf8buf = staticBuffers.byteBuffer(UTF8_BUFFER, 8192);
        byte[] rawUtf8Buf = utf8buf.array();
        CharsetDecoder dec = this.getUTF8Decoder();
        int expectedLen = len > 0 ? (int)(dec.averageCharsPerByte() * (float)len) + 1 : 1024;
        CharBuffer cb = staticBuffers.charBuffer(UTF8_BUFFER, expectedLen);
        try {
            while (len != 0 || utf8buf.position() > 0) {
                if (len < 0) {
                    while (utf8buf.remaining() > 0) {
                        byte b = input.readByte();
                        if (b == 0) {
                            len = 0;
                            break;
                        }
                        utf8buf.put(b);
                    }
                    utf8buf.flip();
                } else if (len > 0) {
                    int r = Math.min(len, utf8buf.remaining());
                    input.readFully(rawUtf8Buf, utf8buf.position(), r);
                    len -= r;
                    utf8buf.limit(utf8buf.position() + r);
                    utf8buf.rewind();
                } else {
                    utf8buf.flip();
                }
                CoderResult cr = dec.decode(utf8buf, cb, len == 0);
                if (cr.isUnderflow()) {
                    utf8buf.compact();
                    continue;
                }
                if (cr.isOverflow()) {
                    utf8buf.compact();
                    CharBuffer newBuf = staticBuffers.charBuffer(UTF8_BUFFER, cb.capacity() + 1024);
                    cb.flip();
                    newBuf.put(cb);
                    cb = newBuf;
                    continue;
                }
                if (!cr.isError()) continue;
                cr.throwException();
            }
            dec.flush(cb);
        }
        finally {
            dec.reset();
            staticBuffers.releaseCharBuffer(UTF8_BUFFER, cb);
            staticBuffers.releaseByteBuffer(UTF8_BUFFER, utf8buf);
        }
        cb.flip();
        return cb.toString();
    }
}

