/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.ListeningStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.io.SuccessMessageLineListener;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.os.OSType;
import de.flapdoodle.os.Platform;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.lang.model.SourceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Processes {
    private static final Logger logger;
    private static final PidHelper PID_HELPER;

    private Processes() {
    }

    public static Long processId(Process process) {
        return PID_HELPER.getPid(process);
    }

    private static Long unixLikeProcessId(Process process) {
        Class<?> clazz = process.getClass();
        try {
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                Object value = pidField.get(process);
                if (value instanceof Integer) {
                    logger.debug("Detected pid: {}", value);
                    return ((Integer)value).longValue();
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException sx) {
            sx.printStackTrace();
        }
        return null;
    }

    private static Long windowsProcessId(Process process) {
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(process);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handl));
                int ret = kernel.GetProcessId(handle);
                logger.debug("Detected pid: {}", (Object)ret);
                return ret;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Consumer<ProcessControl> justWaitALittle() {
        return processControl -> {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        };
    }

    public static boolean killProcess(SupportConfig support, Platform platform, StreamProcessor output, long pid) {
        return Processes.killProcess(support, platform, output, Processes.justWaitALittle(), pid);
    }

    public static boolean killProcess(SupportConfig support, Platform platform, StreamProcessor output, Consumer<ProcessControl> beforeStop, long pid) {
        return Processes.isUnixLike(platform) && ProcessControl.executeCommandLine(support, Arrays.asList("kill", "-2", "" + pid), beforeStop, output, true);
    }

    public static boolean termProcess(SupportConfig support, Platform platform, StreamProcessor output, long pid) {
        return Processes.termProcess(support, platform, output, Processes.justWaitALittle(), pid);
    }

    public static boolean termProcess(SupportConfig support, Platform platform, StreamProcessor output, Consumer<ProcessControl> beforeStop, long pid) {
        return Processes.isUnixLike(platform) && ProcessControl.executeCommandLine(support, Arrays.asList("kill", "" + pid), beforeStop, output, true);
    }

    public static boolean tryKillProcess(SupportConfig support, Platform platform, StreamProcessor output, long pid) {
        return Processes.tryKillProcess(support, platform, output, Processes.justWaitALittle(), pid);
    }

    public static boolean tryKillProcess(SupportConfig support, Platform platform, StreamProcessor output, Consumer<ProcessControl> beforeStop, long pid) {
        return platform.operatingSystem().type() == OSType.Windows && ProcessControl.executeCommandLine(support, Arrays.asList("taskkill", "/F", "/pid", "" + pid), beforeStop, output, true);
    }

    private static boolean isUnixLike(Platform platform) {
        return platform.operatingSystem().type() != OSType.Windows;
    }

    public static boolean isProcessRunning(Platform platform, long pid) {
        try {
            if (Processes.isUnixLike(platform)) {
                Process pidof = Runtime.getRuntime().exec(new String[]{"kill", "-0", "" + pid});
                return pidof.waitFor() == 0;
            }
            String[] cmd = new String[]{"tasklist.exe", "/FI", "PID eq " + pid, "/FO", "CSV"};
            logger.trace("Command: {}", Arrays.asList(cmd));
            ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(Arrays.asList(cmd), true);
            Process process = processBuilder.start();
            SuccessMessageLineListener lineListener = SuccessMessageLineListener.of("" + pid);
            ListeningStreamProcessor logWatch = new ListeningStreamProcessor(StreamToLineProcessor.wrap(Processors.silent()), lineListener::inspect);
            Processors.connect(new InputStreamReader(process.getInputStream()), logWatch);
            lineListener.waitForResult(2000L);
            logger.trace("logWatch output: {}", (Object)lineListener.allLines());
            return lineListener.successMessageFound();
        }
        catch (IOException | InterruptedException e) {
            logger.error("Trying to get process status", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    static {
        String sourceVersion;
        logger = LoggerFactory.getLogger(ProcessControl.class);
        switch (sourceVersion = SourceVersion.latest().toString()) {
            case "RELEASE_8": {
                PID_HELPER = PidHelper.LEGACY;
                break;
            }
            case "RELEASE_9": {
                PID_HELPER = PidHelper.JDK_9;
                break;
            }
            default: {
                PID_HELPER = PidHelper.JDK_11;
            }
        }
    }

    private static enum PidHelper {
        JDK_9{

            @Override
            Long getPid(Process process) {
                try {
                    Method getPid = Process.class.getMethod("getPid", new Class[0]);
                    return (Long)getPid.invoke((Object)process, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        ,
        JDK_11{

            @Override
            Long getPid(Process process) {
                try {
                    Method getPid = Process.class.getMethod("pid", new Class[0]);
                    return (Long)getPid.invoke((Object)process, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        ,
        LEGACY{

            @Override
            Long getPid(Process process) {
                Long pid = Processes.unixLikeProcessId(process);
                if (pid == null) {
                    pid = Processes.windowsProcessId(process);
                }
                return pid;
            }
        };


        abstract Long getPid(Process var1);
    }
}

