/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.net;

import de.flapdoodle.embed.process.config.TimeoutConfig;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;

public interface DownloadToPath {
    public void download(URL var1, Path var2, Optional<Proxy> var3, String var4, TimeoutConfig var5, DownloadCopyListener var6) throws IOException;

    public static DownloadCopyListener downloadCopyListenerDelegatingTo(ProgressListener progressListener) {
        return (url, bytesCopied, contentLength) -> {
            if (bytesCopied == 0L) {
                progressListener.start("download " + url);
            } else if (contentLength != -1L) {
                if (bytesCopied == contentLength) {
                    progressListener.done("download " + url);
                } else {
                    int percent = (int)(bytesCopied * 100L / contentLength);
                    progressListener.progress("download " + url, percent);
                }
            } else {
                progressListener.info("download " + url, bytesCopied + " bytes");
            }
        };
    }

    public static interface DownloadCopyListener {
        public void downloaded(URL var1, long var2, long var4);
    }
}

