/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Executable<T extends ExecutableProcessConfig, P extends IStopable>
implements IStopable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T config;
    private final RuntimeConfig runtimeConfig;
    private final ExtractedFileSet executable;
    private boolean stopped;
    private boolean registeredJobKiller;
    private List<IStopable> stopables = new ArrayList<IStopable>();
    private final Distribution distribution;

    public Executable(Distribution distribution, T config, RuntimeConfig runtimeConfig, ExtractedFileSet executable) {
        this.distribution = distribution;
        this.config = config;
        this.runtimeConfig = runtimeConfig;
        this.executable = executable;
        if (runtimeConfig.isDaemonProcess()) {
            ProcessControl.addShutdownHook(new JobKiller());
            this.registeredJobKiller = true;
        }
    }

    @Override
    public boolean isRegisteredJobKiller() {
        return this.registeredJobKiller;
    }

    @Deprecated
    public synchronized void cleanup() {
        this.stop();
    }

    @Override
    public synchronized void stop() {
        if (!this.stopped) {
            for (IStopable s : this.stopables) {
                s.stop();
            }
            this.stopables = new ArrayList<IStopable>();
            this.runtimeConfig.artifactStore().removeFileSet(this.distribution, this.executable);
            this.stopped = true;
        }
    }

    public ExtractedFileSet getFile() {
        return this.executable;
    }

    public synchronized P start() throws IOException {
        if (this.stopped) {
            throw new RuntimeException("Already stopped");
        }
        P start = this.start(this.distribution, this.config, this.runtimeConfig);
        this.logger.info("start {}", this.config);
        this.addStopable(start);
        return start;
    }

    private void addStopable(P start) {
        this.stopables.add((IStopable)start);
    }

    protected abstract P start(Distribution var1, T var2, RuntimeConfig var3) throws IOException;

    class JobKiller
    implements Runnable {
        JobKiller() {
        }

        @Override
        public void run() {
            Executable.this.stop();
        }
    }
}

