/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.csv.encode;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.csv.config.CsvConfig;
import kotlinx.serialization.csv.encode.CsvWriter$WhenMappings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u0011\u001a\u00020\u000fH\u0002J\"\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\tJ\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0018\u001a\u00020\u0014*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001c\u0010\u0018\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/csv/encode/CsvWriter;", "", "sb", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "config", "Lkotlinx/serialization/csv/config/CsvConfig;", "(Ljava/lang/Appendable;Lkotlinx/serialization/csv/config/CsvConfig;)V", "isFirstColumn", "", "isFirstRecord", "()Z", "setFirstRecord", "(Z)V", "beginRecord", "", "endRecord", "nextColumn", "printColumn", "value", "", "isNumeric", "isNull", "requiresQuoting", "escape", "", "escapeChar", "escapeCharacters", "WriteMode", "library"})
public final class CsvWriter {
    private boolean isFirstRecord;
    private boolean isFirstColumn;
    private final Appendable sb;
    private final CsvConfig config;

    public final boolean isFirstRecord() {
        return this.isFirstRecord;
    }

    public final void setFirstRecord(boolean bl) {
        this.isFirstRecord = bl;
    }

    public final void beginRecord() {
        if (!this.isFirstRecord) {
            this.sb.append(this.config.getRecordSeparator());
        }
    }

    public final void endRecord() {
        if (this.config.getHasTrailingDelimiter()) {
            this.nextColumn();
        }
        this.isFirstRecord = false;
        this.isFirstColumn = true;
    }

    public final void printColumn(@NotNull String value, boolean isNumeric, boolean isNull) {
        WriteMode writeMode;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.nextColumn();
        char delimiter = this.config.getDelimiter();
        String recordSeparator = this.config.getRecordSeparator();
        char quoteChar = this.config.getQuoteChar();
        Character escapeChar = this.config.getEscapeChar();
        switch (CsvWriter$WhenMappings.$EnumSwitchMapping$0[this.config.getQuoteMode().ordinal()]) {
            case 1: {
                writeMode = WriteMode.QUOTED;
                break;
            }
            case 2: {
                if (!isNull || this.requiresQuoting(value)) {
                    writeMode = WriteMode.QUOTED;
                    break;
                }
                writeMode = WriteMode.PLAIN;
                break;
            }
            case 3: {
                if (!isNumeric || this.requiresQuoting(value)) {
                    writeMode = WriteMode.QUOTED;
                    break;
                }
                writeMode = WriteMode.PLAIN;
                break;
            }
            case 4: {
                if (this.requiresQuoting(value)) {
                    writeMode = WriteMode.QUOTED;
                    break;
                }
                writeMode = WriteMode.PLAIN;
                break;
            }
            case 5: {
                writeMode = WriteMode.ESCAPED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        WriteMode mode = writeMode;
        if (mode == WriteMode.ESCAPED && escapeChar != null) {
            String escapedValue = this.escape(value, "" + escapeChar + delimiter + quoteChar + recordSeparator, escapeChar.charValue());
            this.sb.append(escapedValue);
        } else if (mode == WriteMode.QUOTED || mode == WriteMode.ESCAPED) {
            String escapedValue = StringsKt.replace$default((String)value, (String)String.valueOf(quoteChar), (String)("" + quoteChar + quoteChar), (boolean)false, (int)4, null);
            this.sb.append(quoteChar).append(escapedValue).append(quoteChar);
        } else {
            this.sb.append(value);
        }
    }

    public static /* synthetic */ void printColumn$default(CsvWriter csvWriter, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        csvWriter.printColumn(string, bl, bl2);
    }

    private final void nextColumn() {
        if (!this.isFirstColumn) {
            this.sb.append(this.config.getDelimiter());
        }
        this.isFirstColumn = false;
    }

    private final boolean requiresQuoting(String value) {
        Object object = this.config;
        boolean bl = false;
        boolean bl2 = false;
        CsvConfig $this$with = object;
        boolean bl3 = false;
        String chars = "" + $this$with.getDelimiter() + $this$with.getQuoteChar() + $this$with.getRecordSeparator();
        object = value;
        String string = '[' + Regex.Companion.escape(chars) + ']';
        bl2 = false;
        string = new Regex(string);
        bl2 = false;
        return string.containsMatchIn((CharSequence)object);
    }

    /*
     * WARNING - void declaration
     */
    private final String escape(String $this$escape, String escapeCharacters, char escapeChar) {
        void $this$fold$iv;
        CharSequence charSequence = $this$escape;
        StringBuilder initial$iv = new StringBuilder();
        boolean $i$f$fold = false;
        StringBuilder accumulator$iv = initial$iv;
        void var8_8 = $this$fold$iv;
        for (int i = 0; i < var8_8.length(); ++i) {
            StringBuilder stringBuilder;
            void char_;
            char element$iv;
            char c = element$iv = var8_8.charAt(i);
            StringBuilder builder = accumulator$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)escapeCharacters, (char)char_, (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder2 = builder.append(this.escape((char)char_, escapeChar));
                stringBuilder = stringBuilder2;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"builder.append(char.escape(escapeChar))");
            } else {
                StringBuilder stringBuilder3 = builder.append((char)char_);
                stringBuilder = stringBuilder3;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"builder.append(char)");
            }
            accumulator$iv = stringBuilder;
        }
        String string = accumulator$iv.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fold(StringBuilder()) { \u2026   }\n        }.toString()");
        return string;
    }

    private final String escape(char $this$escape, char escapeChar) {
        String string;
        switch ($this$escape) {
            case '\t': {
                string = "" + escapeChar + 't';
                break;
            }
            case '\r': {
                string = "" + escapeChar + 'r';
                break;
            }
            case '\n': {
                string = "" + escapeChar + 'n';
                break;
            }
            case '\b': {
                string = "" + escapeChar + 'b';
                break;
            }
            default: {
                string = "" + escapeChar + $this$escape;
            }
        }
        return string;
    }

    public CsvWriter(@NotNull Appendable sb, @NotNull CsvConfig config) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.sb = sb;
        this.config = config;
        this.isFirstRecord = true;
        this.isFirstColumn = true;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lkotlinx/serialization/csv/encode/CsvWriter$WriteMode;", "", "(Ljava/lang/String;I)V", "QUOTED", "ESCAPED", "PLAIN", "library"})
    private static final class WriteMode
    extends Enum<WriteMode> {
        public static final /* enum */ WriteMode QUOTED;
        public static final /* enum */ WriteMode ESCAPED;
        public static final /* enum */ WriteMode PLAIN;
        private static final /* synthetic */ WriteMode[] $VALUES;

        static {
            WriteMode[] writeModeArray = new WriteMode[3];
            WriteMode[] writeModeArray2 = writeModeArray;
            writeModeArray[0] = QUOTED = new WriteMode();
            writeModeArray[1] = ESCAPED = new WriteMode();
            writeModeArray[2] = PLAIN = new WriteMode();
            $VALUES = writeModeArray;
        }

        public static WriteMode[] values() {
            return (WriteMode[])$VALUES.clone();
        }

        public static WriteMode valueOf(String string) {
            return Enum.valueOf(WriteMode.class, string);
        }
    }
}

