/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.csv.encode;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.csv.Csv;
import kotlinx.serialization.csv.CsvExceptionKt;
import kotlinx.serialization.csv.config.CsvConfig;
import kotlinx.serialization.csv.encode.CsvWriter;
import kotlinx.serialization.csv.encode.ObjectCsvEncoder;
import kotlinx.serialization.csv.encode.SealedCsvEncoder;
import kotlinx.serialization.csv.encode.SimpleCsvEncoder;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0007\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J$\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u001e2\b\b\u0002\u0010'\u001a\u00020\u001eH\u0014J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0019H\u0016J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u00100\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u001cH\u0016J\u0010\u00103\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020%H\u0016J\u0010\u00106\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006;"}, d2={"Lkotlinx/serialization/csv/encode/CsvEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "csv", "Lkotlinx/serialization/csv/Csv;", "writer", "Lkotlinx/serialization/csv/encode/CsvWriter;", "parent", "(Lkotlinx/serialization/csv/Csv;Lkotlinx/serialization/csv/encode/CsvWriter;Lkotlinx/serialization/csv/encode/CsvEncoder;)V", "config", "Lkotlinx/serialization/csv/config/CsvConfig;", "getConfig", "()Lkotlinx/serialization/csv/config/CsvConfig;", "getCsv", "()Lkotlinx/serialization/csv/Csv;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "getWriter", "()Lkotlinx/serialization/csv/encode/CsvWriter;", "beginCollection", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "collectionSize", "", "beginStructure", "encodeBoolean", "", "value", "", "encodeByte", "", "encodeChar", "", "encodeCollectionSize", "encodeColumn", "", "isNumeric", "isNull", "encodeDouble", "", "encodeEnum", "enumDescriptor", "index", "encodeFloat", "", "encodeInt", "encodeLong", "", "encodeNull", "encodeShort", "", "encodeString", "endChildStructure", "endStructure", "printHeader", "prefix", "printHeaderRecord", "library"})
public abstract class CsvEncoder
extends AbstractEncoder {
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Csv csv;
    @NotNull
    private final CsvWriter writer;
    private final CsvEncoder parent;

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    protected final CsvConfig getConfig() {
        return this.csv.getConfig$library();
    }

    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encodeCollectionSize(collectionSize);
        return super.beginCollection(descriptor, collectionSize);
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            compositeEncoder = (CompositeEncoder)new SimpleCsvEncoder(this.csv, this.writer, this);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            compositeEncoder = (CompositeEncoder)new SimpleCsvEncoder(this.csv, this.writer, this);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            compositeEncoder = (CompositeEncoder)new ObjectCsvEncoder(this.csv, this.writer, this);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
            compositeEncoder = (CompositeEncoder)new SealedCsvEncoder(this.csv, this.writer, this, descriptor);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.OPEN.INSTANCE)) {
            compositeEncoder = (CompositeEncoder)new SimpleCsvEncoder(this.csv, this.writer, this);
        } else {
            throw (Throwable)((Object)CsvExceptionKt.UnsupportedSerialDescriptorException(descriptor));
        }
        return compositeEncoder;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            CsvEncoder csvEncoder = this.parent;
            if (csvEncoder == null) break block0;
            csvEncoder.endChildStructure(descriptor);
        }
    }

    protected void endChildStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
    }

    public void encodeByte(byte value) {
        CsvEncoder.encodeColumn$default(this, String.valueOf(value), true, false, 4, null);
    }

    public void encodeShort(short value) {
        CsvEncoder.encodeColumn$default(this, String.valueOf(value), true, false, 4, null);
    }

    public void encodeInt(int value) {
        CsvEncoder.encodeColumn$default(this, String.valueOf(value), true, false, 4, null);
    }

    public void encodeLong(long value) {
        CsvEncoder.encodeColumn$default(this, String.valueOf(value), true, false, 4, null);
    }

    public void encodeFloat(float value) {
        CsvEncoder.encodeColumn$default(this, String.valueOf(value), true, false, 4, null);
    }

    public void encodeDouble(double value) {
        CsvEncoder.encodeColumn$default(this, String.valueOf(value), true, false, 4, null);
    }

    public void encodeBoolean(boolean value) {
        CsvEncoder.encodeColumn$default(this, String.valueOf(value), false, false, 4, null);
    }

    public void encodeChar(char value) {
        CsvEncoder.encodeColumn$default(this, String.valueOf(value), false, false, 6, null);
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CsvEncoder.encodeColumn$default(this, value, false, false, 6, null);
    }

    public void encodeNull() {
        CsvEncoder.encodeColumn$default(this, this.getConfig().getNullString(), false, true, 2, null);
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        CsvEncoder.encodeColumn$default(this, enumDescriptor.getElementName(index), false, false, 6, null);
    }

    protected final void printHeaderRecord(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.writer.beginRecord();
        this.printHeader("", descriptor);
        this.writer.endRecord();
    }

    /*
     * WARNING - void declaration
     */
    private final void printHeader(String prefix, SerialDescriptor descriptor) {
        SerialKind serialKind = descriptor.getKind();
        if (serialKind instanceof StructureKind.LIST || serialKind instanceof StructureKind.MAP || serialKind instanceof PolymorphicKind.OPEN) {
            throw (Throwable)((Object)CsvExceptionKt.HeadersNotSupportedForSerialDescriptorException(descriptor));
        }
        int n = 0;
        int n2 = descriptor.getElementsCount();
        while (n < n2) {
            char headerSeparator;
            void i;
            String name = prefix + descriptor.getElementName((int)i);
            SerialDescriptor childDesc = descriptor.getElementDescriptor((int)i);
            if (childDesc.getKind() instanceof SerialKind.CONTEXTUAL) {
                CsvWriter.printColumn$default(this.writer, name, false, false, 6, null);
            } else if (childDesc.getKind() instanceof SerialKind.ENUM) {
                CsvWriter.printColumn$default(this.writer, name, false, false, 6, null);
            } else if (childDesc.getKind() instanceof PolymorphicKind.SEALED) {
                CsvWriter.printColumn$default(this.writer, name, false, false, 6, null);
                headerSeparator = this.getConfig().getHeaderSeparator();
                this.printHeader(name + headerSeparator, childDesc.getElementDescriptor(1));
            } else if (!(childDesc.getKind() instanceof StructureKind.OBJECT)) {
                if (childDesc.getElementsCount() > 0) {
                    headerSeparator = this.getConfig().getHeaderSeparator();
                    this.printHeader(name + headerSeparator, childDesc);
                } else {
                    CsvWriter.printColumn$default(this.writer, name, false, false, 6, null);
                }
            }
            ++i;
        }
    }

    protected void encodeCollectionSize(int collectionSize) {
        CsvWriter.printColumn$default(this.writer, String.valueOf(collectionSize), true, false, 4, null);
    }

    protected void encodeColumn(@NotNull String value, boolean isNumeric, boolean isNull) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writer.printColumn(value, isNumeric, isNull);
    }

    public static /* synthetic */ void encodeColumn$default(CsvEncoder csvEncoder, String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encodeColumn");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        csvEncoder.encodeColumn(string, bl, bl2);
    }

    @NotNull
    protected final Csv getCsv() {
        return this.csv;
    }

    @NotNull
    protected final CsvWriter getWriter() {
        return this.writer;
    }

    public CsvEncoder(@NotNull Csv csv, @NotNull CsvWriter writer, @Nullable CsvEncoder parent) {
        Intrinsics.checkNotNullParameter((Object)csv, (String)"csv");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.csv = csv;
        this.writer = writer;
        this.parent = parent;
        this.serializersModule = this.csv.getSerializersModule();
    }
}

