/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.csv.decode;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.csv.Csv;
import kotlinx.serialization.csv.decode.CollectionRecordCsvDecoder;
import kotlinx.serialization.csv.decode.CsvDecoder;
import kotlinx.serialization.csv.decode.CsvReader;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/csv/decode/RecordListCsvDecoder;", "Lkotlinx/serialization/csv/decode/CsvDecoder;", "csv", "Lkotlinx/serialization/csv/Csv;", "reader", "Lkotlinx/serialization/csv/decode/CsvReader;", "(Lkotlinx/serialization/csv/Csv;Lkotlinx/serialization/csv/decode/CsvReader;)V", "elementIndex", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeColumn", "", "decodeElementIndex", "endChildStructure", "", "readEmptyLines", "readLastEmptyLine", "library"})
public final class RecordListCsvDecoder
extends CsvDecoder {
    private int elementIndex;

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (descriptor.getKind() instanceof StructureKind.LIST) {
            this.readEmptyLines();
            this.readHeaders(descriptor.getElementDescriptor(0));
        }
        this.readEmptyLines();
        return this.getReader().isDone() ? -1 : this.elementIndex;
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        return Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) ? (CompositeDecoder)new CollectionRecordCsvDecoder(this.getCsv(), this.getReader(), this) : super.beginStructure(descriptor);
    }

    @Override
    protected void endChildStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int n = this.elementIndex;
        this.elementIndex = n + 1;
        this.readTrailingDelimiter();
        this.readEmptyLines();
    }

    @Override
    @NotNull
    protected String decodeColumn() {
        String value = super.decodeColumn();
        this.readTrailingDelimiter();
        int n = this.elementIndex;
        this.elementIndex = n + 1;
        return value;
    }

    private final void readEmptyLines() {
        if (this.getConfig().getIgnoreEmptyLines()) {
            this.getReader().readEmptyLines();
        } else {
            this.readLastEmptyLine();
        }
    }

    private final void readLastEmptyLine() {
        this.getReader().mark();
        this.getReader().readEndOfRecord();
        if (this.getReader().isDone()) {
            this.getReader().unmark();
        } else {
            this.getReader().reset();
        }
    }

    public RecordListCsvDecoder(@NotNull Csv csv, @NotNull CsvReader reader) {
        Intrinsics.checkNotNullParameter((Object)csv, (String)"csv");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(csv, reader, null);
    }
}

