/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.csv.decode;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.csv.config.CsvConfig;
import kotlinx.serialization.csv.decode.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u0017J\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020\u0017H\u0002J\u0006\u0010#\u001a\u00020\u0017J\b\u0010$\u001a\u00020\u001aH\u0016J\u0006\u0010%\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lkotlinx/serialization/csv/decode/CsvReader;", "", "source", "Lkotlinx/serialization/csv/decode/Source;", "config", "Lkotlinx/serialization/csv/config/CsvConfig;", "(Lkotlinx/serialization/csv/decode/Source;Lkotlinx/serialization/csv/config/CsvConfig;)V", "isDone", "", "()Z", "isFirstRecord", "marks", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "offset", "getOffset", "()I", "<set-?>", "recordNo", "getRecordNo", "isNullToken", "mark", "", "read", "expected", "", "readColumn", "readEmptyLines", "readEndOfRecord", "readEscaped", "", "()Ljava/lang/Character;", "readQuotedColumn", "readWhitespace", "reset", "toString", "unmark", "library"})
public final class CsvReader {
    private int recordNo;
    private ArrayList<Integer> marks;
    private final Source source;
    private final CsvConfig config;

    public final int getOffset() {
        return this.source.getOffset();
    }

    public final int getRecordNo() {
        return this.recordNo;
    }

    public final boolean isFirstRecord() {
        return this.recordNo == 0;
    }

    public final boolean isDone() {
        return !this.source.canRead();
    }

    @NotNull
    public final String readColumn() {
        StringBuilder value = new StringBuilder();
        char delimiter = this.config.getDelimiter();
        Character escapeChar = this.config.getEscapeChar();
        char quoteChar = this.config.getQuoteChar();
        while (this.source.canRead()) {
            if (this.read(this.config.getRecordSeparator())) {
                int n = this.recordNo;
                this.recordNo = n + 1;
                break;
            }
            Character c = this.source.read();
            if (c == null) break;
            if (Intrinsics.areEqual((Object)c, (Object)escapeChar)) {
                value.append(this.readEscaped());
                continue;
            }
            if (c.charValue() == delimiter) break;
            if (c.charValue() == quoteChar && StringsKt.isBlank((CharSequence)value)) {
                StringsKt.clear((StringBuilder)value);
                String quoted = this.readQuotedColumn();
                this.readWhitespace();
                return quoted;
            }
            value.append(c.charValue());
        }
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
        return string;
    }

    private final String readQuotedColumn() {
        Character c;
        StringBuilder value = new StringBuilder();
        Character escapeChar = this.config.getEscapeChar();
        char quoteChar = this.config.getQuoteChar();
        while (this.source.canRead() && (c = this.source.read()) != null) {
            if (Intrinsics.areEqual((Object)c, (Object)escapeChar)) {
                Character escaped = this.readEscaped();
                if (escaped == null) continue;
                value.append(escaped.charValue());
                continue;
            }
            if (c.charValue() == quoteChar) {
                Character c2 = this.source.peek();
                if (c2 == null || c2.charValue() != quoteChar) break;
            }
            if (c.charValue() == quoteChar) {
                Character c3 = this.source.peek();
                if (c3 != null && c3.charValue() == quoteChar) {
                    this.source.read();
                    value.append(quoteChar);
                    continue;
                }
            }
            value.append(c.charValue());
        }
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
        return string;
    }

    private final void readWhitespace() {
        while (this.source.canRead()) {
            if (this.read(this.config.getRecordSeparator())) {
                int n = this.recordNo;
                this.recordNo = n + 1;
                break;
            }
            Character c = this.source.read();
            if (c != null && CharsKt.isWhitespace((char)c.charValue())) continue;
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Character readEscaped() {
        Object object;
        Character c;
        Character c2 = c = this.source.read();
        if (c2 != null && c2.charValue() == 't') {
            object = Character.valueOf('\t');
        } else {
            Character c3 = c;
            if (c3 != null && c3.charValue() == 'r') {
                object = Character.valueOf('\r');
            } else {
                Character c4 = c;
                if (c4 != null && c4.charValue() == 'n') {
                    object = Character.valueOf('\n');
                } else {
                    void var1_1;
                    Character c5 = c;
                    object = c5 != null && c5.charValue() == 'b' ? Character.valueOf('\b') : var1_1;
                }
            }
        }
        return object;
    }

    public final void readEmptyLines() {
        while (this.read(this.config.getRecordSeparator())) {
        }
        if (this.source.peek() == null) {
            this.source.read();
        }
    }

    public final void readEndOfRecord() {
        if (this.source.peek() == null) {
            this.source.read();
        } else {
            this.read(this.config.getRecordSeparator());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean read(String expected) {
        this.source.mark();
        int n = 0;
        int n2 = ((CharSequence)expected).length();
        while (n < n2) {
            void i;
            Character c;
            Character c2 = c = this.source.read();
            char c3 = expected.charAt((int)i);
            if (c2 == null || c2.charValue() != c3) {
                this.source.reset();
                return false;
            }
            ++i;
        }
        this.source.unmark();
        return true;
    }

    public final void mark() {
        this.source.mark();
        this.marks.add(this.recordNo);
    }

    public final void unmark() {
        this.source.unmark();
        this.marks.remove(this.marks.size() - 1);
    }

    public final void reset() {
        this.source.reset();
        Integer n = this.marks.remove(this.marks.size() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"marks.removeAt(marks.size - 1)");
        this.recordNo = ((Number)n).intValue();
    }

    public final boolean isNullToken() {
        this.source.mark();
        boolean isNull = Intrinsics.areEqual((Object)this.readColumn(), (Object)this.config.getNullString());
        this.source.reset();
        return isNull;
    }

    @NotNull
    public String toString() {
        return "CsvReader(line=" + this.recordNo + ", source='" + this.source + "')";
    }

    public CsvReader(@NotNull Source source, @NotNull CsvConfig config) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.source = source;
        this.config = config;
        boolean bl = false;
        this.marks = new ArrayList();
    }
}

