/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.csv.decode;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.csv.Csv;
import kotlinx.serialization.csv.CsvExceptionKt;
import kotlinx.serialization.csv.config.CsvConfig;
import kotlinx.serialization.csv.decode.ClassCsvDecoder;
import kotlinx.serialization.csv.decode.CollectionCsvDecoder;
import kotlinx.serialization.csv.decode.CsvReader;
import kotlinx.serialization.csv.decode.ObjectCsvDecoder;
import kotlinx.serialization.csv.decode.SealedCsvDecoder;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001:\u00018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0019H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020%H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u001bH\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020!H\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u00104\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u00105\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u0018\u00105\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00106\u001a\u00020!H\u0002J\b\u00107\u001a\u000203H\u0004R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00069"}, d2={"Lkotlinx/serialization/csv/decode/CsvDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "csv", "Lkotlinx/serialization/csv/Csv;", "reader", "Lkotlinx/serialization/csv/decode/CsvReader;", "parent", "(Lkotlinx/serialization/csv/Csv;Lkotlinx/serialization/csv/decode/CsvReader;Lkotlinx/serialization/csv/decode/CsvDecoder;)V", "config", "Lkotlinx/serialization/csv/config/CsvConfig;", "getConfig", "()Lkotlinx/serialization/csv/config/CsvConfig;", "getCsv", "()Lkotlinx/serialization/csv/Csv;", "headers", "Lkotlinx/serialization/csv/decode/CsvDecoder$Headers;", "getReader", "()Lkotlinx/serialization/csv/decode/CsvReader;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeBoolean", "", "decodeByte", "", "decodeChar", "", "decodeColumn", "", "decodeDouble", "", "decodeEnum", "", "enumDescriptor", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeNotNullMark", "decodeNull", "", "decodeShort", "", "decodeString", "endChildStructure", "", "endStructure", "readHeaders", "prefix", "readTrailingDelimiter", "Headers", "library"})
public abstract class CsvDecoder
extends AbstractDecoder {
    private Headers headers;
    @NotNull
    private final Csv csv;
    @NotNull
    private final CsvReader reader;
    private final CsvDecoder parent;

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.csv.getSerializersModule();
    }

    @NotNull
    protected final CsvConfig getConfig() {
        return this.csv.getConfig$library();
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new CollectionCsvDecoder(this.csv, this.reader, this);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new ClassCsvDecoder(this.csv, this.reader, this, this.headers);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new ObjectCsvDecoder(this.csv, this.reader, this);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new SealedCsvDecoder(this.csv, this.reader, this, descriptor);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.OPEN.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new ClassCsvDecoder(this.csv, this.reader, this, this.headers);
        } else {
            throw (Throwable)((Object)CsvExceptionKt.UnsupportedSerialDescriptorException(descriptor));
        }
        return compositeDecoder;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            CsvDecoder csvDecoder = this.parent;
            if (csvDecoder == null) break block0;
            csvDecoder.endChildStructure(descriptor);
        }
    }

    protected void endChildStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
    }

    public byte decodeByte() {
        String string = this.decodeColumn();
        boolean bl = false;
        return Byte.parseByte(string);
    }

    public short decodeShort() {
        String string = this.decodeColumn();
        boolean bl = false;
        return Short.parseShort(string);
    }

    public int decodeInt() {
        String string = this.decodeColumn();
        boolean bl = false;
        return Integer.parseInt(string);
    }

    public long decodeLong() {
        String string = this.decodeColumn();
        boolean bl = false;
        return Long.parseLong(string);
    }

    public float decodeFloat() {
        String string = this.decodeColumn();
        boolean bl = false;
        return Float.parseFloat(string);
    }

    public double decodeDouble() {
        String string = this.decodeColumn();
        boolean bl = false;
        return Double.parseDouble(string);
    }

    public boolean decodeBoolean() {
        String string = this.decodeColumn();
        boolean bl = false;
        return Boolean.parseBoolean(string);
    }

    public char decodeChar() {
        String value = this.decodeColumn();
        boolean bl = value.length() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return value.charAt(0);
    }

    @NotNull
    public String decodeString() {
        return this.decodeColumn();
    }

    public boolean decodeNotNullMark() {
        return !this.reader.isNullToken();
    }

    @Nullable
    public Void decodeNull() {
        String value = this.decodeColumn();
        boolean bl = Intrinsics.areEqual((Object)value, (Object)this.getConfig().getNullString());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Expected '" + this.getConfig().getNullString() + "' but was '" + value + "'.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return null;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return enumDescriptor.getElementIndex(this.decodeColumn());
    }

    @NotNull
    protected String decodeColumn() {
        return this.reader.readColumn();
    }

    protected final void readHeaders(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.getConfig().getHasHeaderRecord() && this.headers == null) {
            this.headers = this.readHeaders(descriptor, "");
            this.readTrailingDelimiter();
        }
    }

    private final Headers readHeaders(SerialDescriptor descriptor, String prefix) {
        Headers headers = new Headers();
        int position = 0;
        while (!this.reader.isDone() && this.reader.isFirstRecord()) {
            int offset = this.reader.getOffset();
            this.reader.mark();
            String value = this.reader.readColumn();
            if (!StringsKt.startsWith$default((String)value, (String)prefix, (boolean)false, (int)2, null)) {
                this.reader.reset();
                break;
            }
            String header = StringsKt.substringAfter$default((String)value, (String)prefix, null, (int)2, null);
            int headerIndex = descriptor.getElementIndex(header);
            if (headerIndex != -3) {
                headers.set(position, headerIndex);
                this.reader.unmark();
            } else {
                String name = StringsKt.substringBefore$default((String)header, (char)this.getConfig().getHeaderSeparator(), null, (int)2, null);
                int nameIndex = descriptor.getElementIndex(name);
                if (nameIndex != -3) {
                    SerialDescriptor childDesc = descriptor.getElementDescriptor(nameIndex);
                    if (childDesc.getKind() instanceof StructureKind.CLASS) {
                        this.reader.reset();
                        headers.set(position, nameIndex);
                        headers.set(nameIndex, this.readHeaders(childDesc, prefix + name + '.'));
                    } else {
                        this.reader.unmark();
                    }
                } else if (this.csv.getConfig$library().getIgnoreUnknownColumns()) {
                    headers.set(position, -3);
                    this.reader.unmark();
                } else if (Intrinsics.areEqual((Object)value, (Object)"") && !this.reader.isFirstRecord() && this.getConfig().getHasTrailingDelimiter()) {
                    this.reader.unmark();
                } else {
                    throw (Throwable)((Object)CsvExceptionKt.UnknownColumnHeaderException(offset, value));
                }
            }
            ++position;
        }
        return headers;
    }

    protected final void readTrailingDelimiter() {
        if (this.getConfig().getHasTrailingDelimiter()) {
            this.reader.readEndOfRecord();
        }
    }

    @NotNull
    protected final Csv getCsv() {
        return this.csv;
    }

    @NotNull
    protected final CsvReader getReader() {
        return this.reader;
    }

    public CsvDecoder(@NotNull Csv csv, @NotNull CsvReader reader, @Nullable CsvDecoder parent) {
        Intrinsics.checkNotNullParameter((Object)csv, (String)"csv");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.csv = csv;
        this.reader = reader;
        this.parent = parent;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000b\u001a\u00020\u0005J\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0086\u0002J\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlinx/serialization/csv/decode/CsvDecoder$Headers;", "", "()V", "map", "", "", "size", "getSize", "()I", "subHeaders", "get", "position", "(I)Ljava/lang/Integer;", "getSubHeaders", "set", "", "key", "value", "library"})
    public static final class Headers {
        private final Map<Integer, Integer> map;
        private final Map<Integer, Headers> subHeaders;

        public final int getSize() {
            return this.map.size();
        }

        @Nullable
        public final Integer get(int position) {
            return this.map.get(position);
        }

        public final void set(int key, int value) {
            this.map.put(key, value);
        }

        @Nullable
        public final Headers getSubHeaders(int position) {
            Map<Integer, Headers> map = this.subHeaders;
            Integer n = position;
            boolean bl = false;
            Headers headers = map.get(n);
            if (headers == null) {
                boolean bl2 = false;
                headers = null;
            }
            return headers;
        }

        public final void set(int key, @NotNull Headers value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.subHeaders.put(key, value);
        }

        public Headers() {
            boolean bl = false;
            this.map = new LinkedHashMap();
            bl = false;
            this.subHeaders = new LinkedHashMap();
        }
    }
}

