/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.csv;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.csv.config.CsvConfig;
import kotlinx.serialization.csv.decode.CsvReader;
import kotlinx.serialization.csv.decode.RootCsvDecoder;
import kotlinx.serialization.csv.decode.StringSource;
import kotlinx.serialization.csv.encode.RootCsvEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0002\u0018\u0019B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J)\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J)\u0010\u0013\u001a\u00020\u0011\"\u0004\b\u0000\u0010\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u00152\u0006\u0010\u0016\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lkotlinx/serialization/csv/Csv;", "Lkotlinx/serialization/SerialFormat;", "Lkotlinx/serialization/StringFormat;", "config", "Lkotlinx/serialization/csv/config/CsvConfig;", "(Lkotlinx/serialization/csv/config/CsvConfig;)V", "getConfig$library", "()Lkotlinx/serialization/csv/config/CsvConfig;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeFromString", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "string", "", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/String;)Ljava/lang/Object;", "encodeToString", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Ljava/lang/String;", "Default", "Impl", "Lkotlinx/serialization/csv/Csv$Impl;", "Lkotlinx/serialization/csv/Csv$Default;", "library"})
public abstract class Csv
implements SerialFormat,
StringFormat {
    @NotNull
    private final CsvConfig config;
    public static final Default Default = new Default(null);

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.config.getSerializersModule();
    }

    @NotNull
    public <T> String encodeToString(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        StringBuilder result = new StringBuilder();
        new RootCsvEncoder(this, result).encodeSerializableValue(serializer, value);
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    public <T> T decodeFromString(@NotNull DeserializationStrategy<T> deserializer, @NotNull String string) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        CsvReader reader = new CsvReader(new StringSource(string), this.config);
        RootCsvDecoder input = new RootCsvDecoder(this, reader);
        Object result = input.decodeSerializableValue(deserializer);
        boolean bl = reader.isDone();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Reader has not consumed the whole input: " + reader;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return (T)result;
    }

    @NotNull
    public final CsvConfig getConfig$library() {
        return this.config;
    }

    private Csv(CsvConfig config) {
        this.config = config;
    }

    public /* synthetic */ Csv(CsvConfig config, DefaultConstructorMarker $constructor_marker) {
        this(config);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lkotlinx/serialization/csv/Csv$Impl;", "Lkotlinx/serialization/csv/Csv;", "config", "Lkotlinx/serialization/csv/config/CsvConfig;", "(Lkotlinx/serialization/csv/config/CsvConfig;)V", "library"})
    public static final class Impl
    extends Csv {
        public Impl(@NotNull CsvConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            super(config, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lkotlinx/serialization/csv/Csv$Default;", "Lkotlinx/serialization/csv/Csv;", "()V", "Rfc4180", "getRfc4180", "()Lkotlinx/serialization/csv/Csv;", "library"})
    public static final class Default
    extends Csv {
        @NotNull
        public final Csv getRfc4180() {
            return new Impl(CsvConfig.Companion.getRfc4180());
        }

        private Default() {
            super(CsvConfig.Companion.getDefault(), null);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

