/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event;

import com.velocitypowered.api.event.Continuation;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface EventTask {
    public boolean requiresAsync();

    public void execute(Continuation var1);

    public static EventTask async(final Runnable task) {
        Objects.requireNonNull(task, "task");
        return new EventTask(){

            @Override
            public void execute(Continuation continuation) {
                task.run();
                continuation.resume();
            }

            @Override
            public boolean requiresAsync() {
                return true;
            }
        };
    }

    public static EventTask withContinuation(final Consumer<Continuation> task) {
        Objects.requireNonNull(task, "task");
        return new EventTask(){

            @Override
            public void execute(Continuation continuation) {
                task.accept(continuation);
            }

            @Override
            public boolean requiresAsync() {
                return false;
            }
        };
    }

    public static EventTask resumeWhenComplete(CompletableFuture<?> future) {
        Objects.requireNonNull(future, "future");
        return EventTask.withContinuation(continuation -> future.whenComplete((result, cause) -> {
            if (cause != null) {
                continuation.resumeWithException((Throwable)cause);
            } else {
                continuation.resume();
            }
        }));
    }
}

