/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;

public final class ModInfo {
    public static final ModInfo DEFAULT = new ModInfo("FML", (List<Mod>)ImmutableList.of());
    private final String type;
    private final List<Mod> modList;

    public ModInfo(String type, List<Mod> modList) {
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.modList = ImmutableList.copyOf(modList);
    }

    public String getType() {
        return this.type;
    }

    public List<Mod> getMods() {
        return this.modList;
    }

    public String toString() {
        return "ModInfo{type='" + this.type + "', modList=" + this.modList + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModInfo modInfo = (ModInfo)o;
        return this.type.equals(modInfo.type) && this.modList.equals(modInfo.modList);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.modList);
    }

    public static final class Mod {
        @SerializedName(value="modid")
        private final String id;
        private final String version;

        public Mod(String id, String version) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            Preconditions.checkArgument((id.length() < 128 ? 1 : 0) != 0, (Object)"mod id is too long");
            Preconditions.checkArgument((version.length() < 128 ? 1 : 0) != 0, (Object)"mod version is too long");
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "Mod{id='" + this.id + "', version='" + this.version + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mod mod = (Mod)o;
            return this.id.equals(mod.id) && this.version.equals(mod.version);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version);
        }
    }
}

