/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.messages;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import java.util.Objects;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MinecraftChannelIdentifier
implements ChannelIdentifier {
    private static final Pattern VALID_IDENTIFIER_REGEX = Pattern.compile("[a-z0-9\\-_]*");
    private final String namespace;
    private final String name;

    private MinecraftChannelIdentifier(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public static MinecraftChannelIdentifier forDefaultNamespace(String name) {
        return new MinecraftChannelIdentifier("minecraft", name);
    }

    public static MinecraftChannelIdentifier create(String namespace, String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace is null or empty");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"namespace is null or empty");
        Preconditions.checkArgument((boolean)VALID_IDENTIFIER_REGEX.matcher(namespace).matches(), (Object)"namespace is not valid");
        Preconditions.checkArgument((boolean)VALID_IDENTIFIER_REGEX.matcher(name).matches(), (Object)"name is not valid");
        return new MinecraftChannelIdentifier(namespace, name);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.namespace + ":" + this.name + " (modern)";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinecraftChannelIdentifier that = (MinecraftChannelIdentifier)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }

    @Override
    public String getId() {
        return this.namespace + ":" + this.name;
    }
}

