/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

public enum ProtocolVersion {
    UNKNOWN(-1, "Unknown"),
    LEGACY(-2, "Legacy"),
    MINECRAFT_1_8(47, "1.8"),
    MINECRAFT_1_9(107, "1.9"),
    MINECRAFT_1_9_1(108, "1.9.1"),
    MINECRAFT_1_9_2(109, "1.9.2"),
    MINECRAFT_1_9_4(110, "1.9.4"),
    MINECRAFT_1_10(210, "1.10"),
    MINECRAFT_1_11(315, "1.11"),
    MINECRAFT_1_11_1(316, "1.11.1"),
    MINECRAFT_1_12(335, "1.12"),
    MINECRAFT_1_12_1(338, "1.12.1"),
    MINECRAFT_1_12_2(340, "1.12.2"),
    MINECRAFT_1_13(393, "1.13"),
    MINECRAFT_1_13_1(401, "1.13.1"),
    MINECRAFT_1_13_2(404, "1.13.2"),
    MINECRAFT_1_14(477, "1.14"),
    MINECRAFT_1_14_1(480, "1.14.1"),
    MINECRAFT_1_14_2(485, "1.14.2");

    private final int protocol;
    private final String name;
    public static final ProtocolVersion MINIMUM_VERSION;
    public static final ProtocolVersion MAXIMUM_VERSION;
    public static final String SUPPORTED_VERSION_STRING;
    public static final ImmutableMap<Integer, ProtocolVersion> ID_TO_PROTOCOL_CONSTANT;
    public static final Set<ProtocolVersion> SUPPORTED_VERSIONS;

    private ProtocolVersion(int protocol, String name) {
        this.protocol = protocol;
        this.name = name;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public String getName() {
        return this.name;
    }

    public static ProtocolVersion getProtocolVersion(int protocol) {
        return (ProtocolVersion)((Object)ID_TO_PROTOCOL_CONSTANT.getOrDefault((Object)protocol, (Object)UNKNOWN));
    }

    public static boolean isSupported(int protocol) {
        ProtocolVersion version = (ProtocolVersion)((Object)ID_TO_PROTOCOL_CONSTANT.get((Object)protocol));
        return version != null && !version.isUnknown();
    }

    public static boolean isSupported(ProtocolVersion version) {
        return version != null && !version.isUnknown();
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isLegacy() {
        return this == LEGACY;
    }

    public String toString() {
        return this.name;
    }

    static {
        MINIMUM_VERSION = MINECRAFT_1_8;
        MAXIMUM_VERSION = ProtocolVersion.values()[ProtocolVersion.values().length - 1];
        SUPPORTED_VERSION_STRING = String.format("%s-%s", new Object[]{MINIMUM_VERSION, MAXIMUM_VERSION});
        Cloneable versions = new HashMap<Integer, ProtocolVersion>();
        for (ProtocolVersion version : ProtocolVersion.values()) {
            versions.put(version.protocol, version);
        }
        ID_TO_PROTOCOL_CONSTANT = ImmutableMap.copyOf(versions);
        versions = EnumSet.noneOf(ProtocolVersion.class);
        for (ProtocolVersion value : ProtocolVersion.values()) {
            if (value.isUnknown() || value.isLegacy()) continue;
            versions.add(value);
        }
        SUPPORTED_VERSIONS = Sets.immutableEnumSet(versions);
    }
}

