/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import net.kyori.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KickedFromServerEvent
implements ResultedEvent<ServerKickResult> {
    private final Player player;
    private final RegisteredServer server;
    private final @Nullable Component originalReason;
    private final boolean duringServerConnect;
    private ServerKickResult result;

    public KickedFromServerEvent(Player player, RegisteredServer server, @Nullable Component originalReason, boolean duringServerConnect, Component fancyReason) {
        this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player");
        this.server = (RegisteredServer)Preconditions.checkNotNull((Object)server, (Object)"server");
        this.originalReason = originalReason;
        this.duringServerConnect = duringServerConnect;
        this.result = new Notify(fancyReason);
    }

    public KickedFromServerEvent(Player player, RegisteredServer server, @Nullable Component originalReason, boolean duringServerConnect, ServerKickResult result) {
        this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player");
        this.server = (RegisteredServer)Preconditions.checkNotNull((Object)server, (Object)"server");
        this.originalReason = originalReason;
        this.duringServerConnect = duringServerConnect;
        this.result = (ServerKickResult)Preconditions.checkNotNull((Object)result, (Object)"result");
    }

    @Override
    public ServerKickResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NonNull ServerKickResult result) {
        this.result = (ServerKickResult)Preconditions.checkNotNull((Object)result, (Object)"result");
    }

    public Player getPlayer() {
        return this.player;
    }

    public RegisteredServer getServer() {
        return this.server;
    }

    public Optional<Component> getOriginalReason() {
        return Optional.ofNullable(this.originalReason);
    }

    public boolean kickedDuringServerConnect() {
        return this.duringServerConnect;
    }

    @Deprecated
    public boolean kickedDuringLogin() {
        return this.duringServerConnect;
    }

    public static final class Notify
    implements ServerKickResult {
        private final Component message;

        private Notify(Component message) {
            this.message = (Component)Preconditions.checkNotNull((Object)message, (Object)"message");
        }

        @Override
        public boolean isAllowed() {
            return false;
        }

        public Component getMessage() {
            return this.message;
        }

        public static Notify create(Component message) {
            return new Notify(message);
        }
    }

    public static final class RedirectPlayer
    implements ServerKickResult {
        private final RegisteredServer server;

        private RedirectPlayer(RegisteredServer server) {
            this.server = (RegisteredServer)Preconditions.checkNotNull((Object)server, (Object)"server");
        }

        @Override
        public boolean isAllowed() {
            return false;
        }

        public RegisteredServer getServer() {
            return this.server;
        }

        public static RedirectPlayer create(RegisteredServer server) {
            return new RedirectPlayer(server);
        }
    }

    public static final class DisconnectPlayer
    implements ServerKickResult {
        private final Component component;

        private DisconnectPlayer(Component component) {
            this.component = (Component)Preconditions.checkNotNull((Object)component, (Object)"component");
        }

        @Override
        public boolean isAllowed() {
            return true;
        }

        public Component getReason() {
            return this.component;
        }

        public static DisconnectPlayer create(Component reason) {
            return new DisconnectPlayer(reason);
        }
    }

    public static interface ServerKickResult
    extends ResultedEvent.Result {
    }
}

