/*
 * Decompiled with CFR 0.152.
 */
package com.uchuhimo.konf.source.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.uchuhimo.konf.Feature;
import com.uchuhimo.konf.TreeNode;
import com.uchuhimo.konf.source.Source;
import com.uchuhimo.konf.source.SourceInfo;
import com.uchuhimo.konf.source.hocon.HoconSourceKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/uchuhimo/konf/source/hocon/HoconSource;", "Lcom/uchuhimo/konf/source/Source;", "value", "Lcom/typesafe/config/Config;", "(Lcom/typesafe/config/Config;)V", "info", "Lcom/uchuhimo/konf/source/SourceInfo;", "getInfo", "()Lcom/uchuhimo/konf/source/SourceInfo;", "tree", "Lcom/uchuhimo/konf/TreeNode;", "getTree", "()Lcom/uchuhimo/konf/TreeNode;", "getValue", "()Lcom/typesafe/config/Config;", "konf-hocon"})
public final class HoconSource
implements Source {
    @NotNull
    private final SourceInfo info;
    @NotNull
    private final TreeNode tree;
    @NotNull
    private final Config value;

    @NotNull
    public SourceInfo getInfo() {
        return this.info;
    }

    @NotNull
    public TreeNode getTree() {
        return this.tree;
    }

    @NotNull
    public final Config getValue() {
        return this.value;
    }

    public HoconSource(@NotNull Config value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.info = new SourceInfo(new Pair[]{TuplesKt.to((Object)"type", (Object)"HOCON")});
        ConfigObject configObject = this.value.root();
        Intrinsics.checkNotNullExpressionValue((Object)configObject, (String)"value.root()");
        this.tree = HoconSourceKt.access$toTree((ConfigValue)configObject);
    }

    @NotNull
    public String getDescription() {
        return Source.DefaultImpls.getDescription((Source)this);
    }

    @NotNull
    public Map<Feature, Boolean> getFeatures() {
        return Source.DefaultImpls.getFeatures((Source)this);
    }

    public boolean contains(@NotNull List<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Source.DefaultImpls.contains((Source)this, path);
    }

    public boolean contains(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return Source.DefaultImpls.contains((Source)this, (String)prefix);
    }

    @NotNull
    public Source disabled(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return Source.DefaultImpls.disabled((Source)this, (Feature)feature);
    }

    @NotNull
    public Source enabled(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return Source.DefaultImpls.enabled((Source)this, (Feature)feature);
    }

    @NotNull
    public Source get(@NotNull List<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Source.DefaultImpls.get((Source)this, path);
    }

    @NotNull
    public Source get(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Source.DefaultImpls.get((Source)this, (String)path);
    }

    @Nullable
    public TreeNode getNodeOrNull(@NotNull List<String> path, boolean lowercased, boolean littleCamelCased) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Source.DefaultImpls.getNodeOrNull((Source)this, path, (boolean)lowercased, (boolean)littleCamelCased);
    }

    @Nullable
    public Source getOrNull(@NotNull List<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Source.DefaultImpls.getOrNull((Source)this, path);
    }

    @Nullable
    public Source getOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Source.DefaultImpls.getOrNull((Source)this, (String)path);
    }

    public boolean isEnabled(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return Source.DefaultImpls.isEnabled((Source)this, (Feature)feature);
    }

    @NotNull
    public Source littleCamelCased(boolean enabled) {
        return Source.DefaultImpls.littleCamelCased((Source)this, (boolean)enabled);
    }

    @NotNull
    public Source lowercased(boolean enabled) {
        return Source.DefaultImpls.lowercased((Source)this, (boolean)enabled);
    }

    @NotNull
    public Source normalized(boolean lowercased, boolean littleCamelCased) {
        return Source.DefaultImpls.normalized((Source)this, (boolean)lowercased, (boolean)littleCamelCased);
    }

    @NotNull
    public Source plus(@NotNull Source facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        return Source.DefaultImpls.plus((Source)this, (Source)facade);
    }

    @NotNull
    public Source substituted(@NotNull Source root, boolean enabled, boolean errorWhenUndefined) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return Source.DefaultImpls.substituted((Source)this, (Source)root, (boolean)enabled, (boolean)errorWhenUndefined);
    }

    @NotNull
    public Source withFallback(@NotNull Source fallback) {
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        return Source.DefaultImpls.withFallback((Source)this, (Source)fallback);
    }

    @NotNull
    public Source withPrefix(@NotNull List<String> prefix) {
        Intrinsics.checkNotNullParameter(prefix, (String)"prefix");
        return Source.DefaultImpls.withPrefix((Source)this, prefix);
    }

    @NotNull
    public Source withPrefix(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return Source.DefaultImpls.withPrefix((Source)this, (String)prefix);
    }
}

