/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="A list of metrics for this user")
public class UserPublicMetrics {
    public static final String SERIALIZED_NAME_FOLLOWERS_COUNT = "followers_count";
    @SerializedName(value="followers_count")
    private Integer followersCount;
    public static final String SERIALIZED_NAME_FOLLOWING_COUNT = "following_count";
    @SerializedName(value="following_count")
    private Integer followingCount;
    public static final String SERIALIZED_NAME_TWEET_COUNT = "tweet_count";
    @SerializedName(value="tweet_count")
    private Integer tweetCount;
    public static final String SERIALIZED_NAME_LISTED_COUNT = "listed_count";
    @SerializedName(value="listed_count")
    private Integer listedCount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UserPublicMetrics followersCount(Integer followersCount) {
        this.followersCount = followersCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of users who are following this user.")
    public Integer getFollowersCount() {
        return this.followersCount;
    }

    public void setFollowersCount(Integer followersCount) {
        this.followersCount = followersCount;
    }

    public UserPublicMetrics followingCount(Integer followingCount) {
        this.followingCount = followingCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of users this user is following.")
    public Integer getFollowingCount() {
        return this.followingCount;
    }

    public void setFollowingCount(Integer followingCount) {
        this.followingCount = followingCount;
    }

    public UserPublicMetrics tweetCount(Integer tweetCount) {
        this.tweetCount = tweetCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The number of Tweets (including Retweets) posted by this user.")
    public Integer getTweetCount() {
        return this.tweetCount;
    }

    public void setTweetCount(Integer tweetCount) {
        this.tweetCount = tweetCount;
    }

    public UserPublicMetrics listedCount(Integer listedCount) {
        this.listedCount = listedCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The number of lists that include this user.")
    public Integer getListedCount() {
        return this.listedCount;
    }

    public void setListedCount(Integer listedCount) {
        this.listedCount = listedCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPublicMetrics userPublicMetrics = (UserPublicMetrics)o;
        return Objects.equals(this.followersCount, userPublicMetrics.followersCount) && Objects.equals(this.followingCount, userPublicMetrics.followingCount) && Objects.equals(this.tweetCount, userPublicMetrics.tweetCount) && Objects.equals(this.listedCount, userPublicMetrics.listedCount);
    }

    public int hashCode() {
        return Objects.hash(this.followersCount, this.followingCount, this.tweetCount, this.listedCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserPublicMetrics {\n");
        sb.append("    followersCount: ").append(this.toIndentedString(this.followersCount)).append("\n");
        sb.append("    followingCount: ").append(this.toIndentedString(this.followingCount)).append("\n");
        sb.append("    tweetCount: ").append(this.toIndentedString(this.tweetCount)).append("\n");
        sb.append("    listedCount: ").append(this.toIndentedString(this.listedCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static UserPublicMetrics fromJson(String jsonString) throws IOException {
        return (UserPublicMetrics)JSON.getGson().fromJson(jsonString, UserPublicMetrics.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FOLLOWERS_COUNT);
        openapiFields.add(SERIALIZED_NAME_FOLLOWING_COUNT);
        openapiFields.add(SERIALIZED_NAME_TWEET_COUNT);
        openapiFields.add(SERIALIZED_NAME_LISTED_COUNT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_FOLLOWERS_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_FOLLOWING_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_TWEET_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_LISTED_COUNT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UserPublicMetrics.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UserPublicMetrics.class));
            return new TypeAdapter<UserPublicMetrics>(){

                public void write(JsonWriter out, UserPublicMetrics value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UserPublicMetrics read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UserPublicMetrics.validateJsonObject(jsonObj);
                    return (UserPublicMetrics)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

