/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Nonpublic engagement metrics for the Tweet at the time of the request.")
public class TweetNonPublicMetrics {
    public static final String SERIALIZED_NAME_IMPRESSION_COUNT = "impression_count";
    @SerializedName(value="impression_count")
    private Integer impressionCount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetNonPublicMetrics impressionCount(Integer impressionCount) {
        this.impressionCount = impressionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been viewed.")
    public Integer getImpressionCount() {
        return this.impressionCount;
    }

    public void setImpressionCount(Integer impressionCount) {
        this.impressionCount = impressionCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetNonPublicMetrics tweetNonPublicMetrics = (TweetNonPublicMetrics)o;
        return Objects.equals(this.impressionCount, tweetNonPublicMetrics.impressionCount);
    }

    public int hashCode() {
        return Objects.hash(this.impressionCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetNonPublicMetrics {\n");
        sb.append("    impressionCount: ").append(this.toIndentedString(this.impressionCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
    }

    public static TweetNonPublicMetrics fromJson(String jsonString) throws IOException {
        return (TweetNonPublicMetrics)JSON.getGson().fromJson(jsonString, TweetNonPublicMetrics.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_IMPRESSION_COUNT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetNonPublicMetrics.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetNonPublicMetrics.class));
            return new TypeAdapter<TweetNonPublicMetrics>(){

                public void write(JsonWriter out, TweetNonPublicMetrics value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetNonPublicMetrics read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetNonPublicMetrics.validateJsonObject(jsonObj);
                    return (TweetNonPublicMetrics)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

