/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.ClientDisconnectedProblem;
import com.twitter.clientlib.model.ClientForbiddenProblem;
import com.twitter.clientlib.model.ConflictProblem;
import com.twitter.clientlib.model.ConnectionExceptionProblem;
import com.twitter.clientlib.model.DisallowedResourceProblem;
import com.twitter.clientlib.model.DuplicateRuleProblem;
import com.twitter.clientlib.model.FieldUnauthorizedProblem;
import com.twitter.clientlib.model.GenericProblem;
import com.twitter.clientlib.model.InvalidRequestProblem;
import com.twitter.clientlib.model.InvalidRuleProblem;
import com.twitter.clientlib.model.NonCompliantRulesProblem;
import com.twitter.clientlib.model.OperationalDisconnectProblem;
import com.twitter.clientlib.model.ResourceNotFoundProblem;
import com.twitter.clientlib.model.ResourceUnauthorizedProblem;
import com.twitter.clientlib.model.ResourceUnavailableProblem;
import com.twitter.clientlib.model.RulesCapProblem;
import com.twitter.clientlib.model.UnsupportedAuthenticationProblem;
import com.twitter.clientlib.model.UsageCapExceededProblem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="An HTTP Problem Details object, as defined in IETF RFC 7807 (https://tools.ietf.org/html/rfc7807).")
public class Problem {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    protected String type = this.getClass().getSimpleName();
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DETAIL = "detail";
    @SerializedName(value="detail")
    private String detail;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private Integer status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Problem type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Problem title(String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Problem detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Problem status(Integer status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Problem problem = (Problem)o;
        return Objects.equals(this.type, problem.type) && Objects.equals(this.title, problem.title) && Objects.equals(this.detail, problem.detail) && Objects.equals(this.status, problem.status);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.title, this.detail, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Problem {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        String discriminatorValue;
        switch (discriminatorValue = jsonObj.get(SERIALIZED_NAME_TYPE).getAsString()) {
            case "ClientDisconnectedProblem": {
                ClientDisconnectedProblem.validateJsonObject(jsonObj);
                break;
            }
            case "ClientForbiddenProblem": {
                ClientForbiddenProblem.validateJsonObject(jsonObj);
                break;
            }
            case "ConflictProblem": {
                ConflictProblem.validateJsonObject(jsonObj);
                break;
            }
            case "ConnectionExceptionProblem": {
                ConnectionExceptionProblem.validateJsonObject(jsonObj);
                break;
            }
            case "DisallowedResourceProblem": {
                DisallowedResourceProblem.validateJsonObject(jsonObj);
                break;
            }
            case "DuplicateRuleProblem": {
                DuplicateRuleProblem.validateJsonObject(jsonObj);
                break;
            }
            case "FieldUnauthorizedProblem": {
                FieldUnauthorizedProblem.validateJsonObject(jsonObj);
                break;
            }
            case "GenericProblem": {
                GenericProblem.validateJsonObject(jsonObj);
                break;
            }
            case "InvalidRequestProblem": {
                InvalidRequestProblem.validateJsonObject(jsonObj);
                break;
            }
            case "InvalidRuleProblem": {
                InvalidRuleProblem.validateJsonObject(jsonObj);
                break;
            }
            case "NonCompliantRulesProblem": {
                NonCompliantRulesProblem.validateJsonObject(jsonObj);
                break;
            }
            case "OperationalDisconnectProblem": {
                OperationalDisconnectProblem.validateJsonObject(jsonObj);
                break;
            }
            case "ResourceNotFoundProblem": {
                ResourceNotFoundProblem.validateJsonObject(jsonObj);
                break;
            }
            case "ResourceUnauthorizedProblem": {
                ResourceUnauthorizedProblem.validateJsonObject(jsonObj);
                break;
            }
            case "ResourceUnavailableProblem": {
                ResourceUnavailableProblem.validateJsonObject(jsonObj);
                break;
            }
            case "RulesCapProblem": {
                RulesCapProblem.validateJsonObject(jsonObj);
                break;
            }
            case "UnsupportedAuthenticationProblem": {
                UnsupportedAuthenticationProblem.validateJsonObject(jsonObj);
                break;
            }
            case "UsageCapExceededProblem": {
                UsageCapExceededProblem.validateJsonObject(jsonObj);
                break;
            }
            case "about:blank": {
                GenericProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/client-disconnected": {
                ClientDisconnectedProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/client-forbidden": {
                ClientForbiddenProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/conflict": {
                ConflictProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/disallowed-resource": {
                DisallowedResourceProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/duplicate-rules": {
                DuplicateRuleProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/invalid-request": {
                InvalidRequestProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/invalid-rules": {
                InvalidRuleProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/noncompliant-rules": {
                NonCompliantRulesProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/not-authorized-for-field": {
                FieldUnauthorizedProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/not-authorized-for-resource": {
                ResourceUnauthorizedProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/operational-disconnect": {
                OperationalDisconnectProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/resource-not-found": {
                ResourceNotFoundProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/resource-unavailable": {
                ResourceUnavailableProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/rule-cap": {
                RulesCapProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/streaming-connection": {
                ConnectionExceptionProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/unsupported-authentication": {
                UnsupportedAuthenticationProblem.validateJsonObject(jsonObj);
                break;
            }
            case "https://api.twitter.com/2/problems/usage-capped": {
                UsageCapExceededProblem.validateJsonObject(jsonObj);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value of the `type` field `%s` does not match any key defined in the discriminator's mapping.", discriminatorValue));
            }
        }
    }

    public static Problem fromJson(String jsonString) throws IOException {
        return (Problem)JSON.getGson().fromJson(jsonString, Problem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_DETAIL);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_TITLE);
    }
}

