/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.ComplianceJobType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="A request to create a new batch compliance job.")
public class CreateBatchComplianceJobRequest {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private ComplianceJobType type;
    public static final String SERIALIZED_NAME_RESUMABLE = "resumable";
    @SerializedName(value="resumable")
    private Boolean resumable;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateBatchComplianceJobRequest type(ComplianceJobType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ComplianceJobType getType() {
        return this.type;
    }

    public void setType(ComplianceJobType type) {
        this.type = type;
    }

    public CreateBatchComplianceJobRequest resumable(Boolean resumable) {
        this.resumable = resumable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, this endpoint will return a pre-signed URL with resumable uploads enabled")
    public Boolean getResumable() {
        return this.resumable;
    }

    public void setResumable(Boolean resumable) {
        this.resumable = resumable;
    }

    public CreateBatchComplianceJobRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="my-job", value="User-provided name for a compliance job")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateBatchComplianceJobRequest createBatchComplianceJobRequest = (CreateBatchComplianceJobRequest)o;
        return Objects.equals((Object)this.type, (Object)createBatchComplianceJobRequest.type) && Objects.equals(this.resumable, createBatchComplianceJobRequest.resumable) && Objects.equals(this.name, createBatchComplianceJobRequest.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.resumable, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateBatchComplianceJobRequest {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    resumable: ").append(this.toIndentedString(this.resumable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static CreateBatchComplianceJobRequest fromJson(String jsonString) throws IOException {
        return (CreateBatchComplianceJobRequest)JSON.getGson().fromJson(jsonString, CreateBatchComplianceJobRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_RESUMABLE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateBatchComplianceJobRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateBatchComplianceJobRequest.class));
            return new TypeAdapter<CreateBatchComplianceJobRequest>(){

                public void write(JsonWriter out, CreateBatchComplianceJobRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateBatchComplianceJobRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateBatchComplianceJobRequest.validateJsonObject(jsonObj);
                    return (CreateBatchComplianceJobRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

