/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.URLImage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represent the portion of text recognized as a URL.")
public class URLFields {
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private URI url;
    public static final String SERIALIZED_NAME_EXPANDED_URL = "expanded_url";
    @SerializedName(value="expanded_url")
    private URI expandedUrl;
    public static final String SERIALIZED_NAME_DISPLAY_URL = "display_url";
    @SerializedName(value="display_url")
    private String displayUrl;
    public static final String SERIALIZED_NAME_UNWOUND_URL = "unwound_url";
    @SerializedName(value="unwound_url")
    private URI unwoundUrl;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private Integer status;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_IMAGES = "images";
    @SerializedName(value="images")
    private List<URLImage> images = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public URLFields url(URI url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://developer.twitter.com/en/docs/twitter-api", required=true, value="A validly formatted URL.")
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public URLFields expandedUrl(URI expandedUrl) {
        this.expandedUrl = expandedUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://developer.twitter.com/en/docs/twitter-api", value="A validly formatted URL.")
    public URI getExpandedUrl() {
        return this.expandedUrl;
    }

    public void setExpandedUrl(URI expandedUrl) {
        this.expandedUrl = expandedUrl;
    }

    public URLFields displayUrl(String displayUrl) {
        this.displayUrl = displayUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="twittercommunity.com/t/introducing-\u2026", value="The URL as displayed in the Twitter client.")
    public String getDisplayUrl() {
        return this.displayUrl;
    }

    public void setDisplayUrl(String displayUrl) {
        this.displayUrl = displayUrl;
    }

    public URLFields unwoundUrl(URI unwoundUrl) {
        this.unwoundUrl = unwoundUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://twittercommunity.com/t/introducing-the-v2-follow-lookup-endpoints/147118", value="Fully resolved url")
    public URI getUnwoundUrl() {
        return this.unwoundUrl;
    }

    public void setUnwoundUrl(URI unwoundUrl) {
        this.unwoundUrl = unwoundUrl;
    }

    public URLFields status(Integer status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HTTP Status Code.")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public URLFields title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Introducing the v2 follow lookup endpoints", value="Title of the page the URL points to.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public URLFields description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is a description of the website.", value="Description of the URL landing page.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public URLFields images(List<URLImage> images) {
        this.images = images;
        return this;
    }

    public URLFields addImagesItem(URLImage imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<URLImage>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<URLImage> getImages() {
        return this.images;
    }

    public void setImages(List<URLImage> images) {
        this.images = images;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLFields urLFields = (URLFields)o;
        return Objects.equals(this.url, urLFields.url) && Objects.equals(this.expandedUrl, urLFields.expandedUrl) && Objects.equals(this.displayUrl, urLFields.displayUrl) && Objects.equals(this.unwoundUrl, urLFields.unwoundUrl) && Objects.equals(this.status, urLFields.status) && Objects.equals(this.title, urLFields.title) && Objects.equals(this.description, urLFields.description) && Objects.equals(this.images, urLFields.images);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.expandedUrl, this.displayUrl, this.unwoundUrl, this.status, this.title, this.description, this.images);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class URLFields {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    expandedUrl: ").append(this.toIndentedString(this.expandedUrl)).append("\n");
        sb.append("    displayUrl: ").append(this.toIndentedString(this.displayUrl)).append("\n");
        sb.append("    unwoundUrl: ").append(this.toIndentedString(this.unwoundUrl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in URLFields is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `URLFields` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArrayimages = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGES);
        if (jsonArrayimages != null) {
            for (int i = 0; i < jsonArrayimages.size(); ++i) {
                URLImage.validateJsonObject(jsonArrayimages.get(i).getAsJsonObject());
            }
        }
    }

    public static URLFields fromJson(String jsonString) throws IOException {
        return (URLFields)JSON.getGson().fromJson(jsonString, URLFields.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_EXPANDED_URL);
        openapiFields.add(SERIALIZED_NAME_DISPLAY_URL);
        openapiFields.add(SERIALIZED_NAME_UNWOUND_URL);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_IMAGES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!URLFields.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(URLFields.class));
            return new TypeAdapter<URLFields>(){

                public void write(JsonWriter out, URLFields value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public URLFields read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    URLFields.validateJsonObject(jsonObj);
                    return (URLFields)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

