/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="Specifies the type of attachments (if any) present in this Tweet.")
public class TweetAttachments {
    public static final String SERIALIZED_NAME_MEDIA_KEYS = "media_keys";
    @SerializedName(value="media_keys")
    private List<String> mediaKeys = null;
    public static final String SERIALIZED_NAME_POLL_IDS = "poll_ids";
    @SerializedName(value="poll_ids")
    private List<String> pollIds = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetAttachments mediaKeys(List<String> mediaKeys) {
        this.mediaKeys = mediaKeys;
        return this;
    }

    public TweetAttachments addMediaKeysItem(String mediaKeysItem) {
        if (this.mediaKeys == null) {
            this.mediaKeys = new ArrayList<String>();
        }
        this.mediaKeys.add(mediaKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of Media Keys for each one of the media attachments (if media are attached).")
    public List<String> getMediaKeys() {
        return this.mediaKeys;
    }

    public void setMediaKeys(List<String> mediaKeys) {
        this.mediaKeys = mediaKeys;
    }

    public TweetAttachments pollIds(List<String> pollIds) {
        this.pollIds = pollIds;
        return this;
    }

    public TweetAttachments addPollIdsItem(String pollIdsItem) {
        if (this.pollIds == null) {
            this.pollIds = new ArrayList<String>();
        }
        this.pollIds.add(pollIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of poll IDs (if polls are attached).")
    public List<String> getPollIds() {
        return this.pollIds;
    }

    public void setPollIds(List<String> pollIds) {
        this.pollIds = pollIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetAttachments tweetAttachments = (TweetAttachments)o;
        return Objects.equals(this.mediaKeys, tweetAttachments.mediaKeys) && Objects.equals(this.pollIds, tweetAttachments.pollIds);
    }

    public int hashCode() {
        return Objects.hash(this.mediaKeys, this.pollIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetAttachments {\n");
        sb.append("    mediaKeys: ").append(this.toIndentedString(this.mediaKeys)).append("\n");
        sb.append("    pollIds: ").append(this.toIndentedString(this.pollIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TweetAttachments is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TweetAttachments` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
    }

    public static TweetAttachments fromJson(String jsonString) throws IOException {
        return (TweetAttachments)JSON.getGson().fromJson(jsonString, TweetAttachments.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MEDIA_KEYS);
        openapiFields.add(SERIALIZED_NAME_POLL_IDS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetAttachments.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetAttachments.class));
            return new TypeAdapter<TweetAttachments>(){

                public void write(JsonWriter out, TweetAttachments value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetAttachments read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetAttachments.validateJsonObject(jsonObj);
                    return (TweetAttachments)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

