/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Expansions;
import com.twitter.clientlib.model.FilteredStreamingTweetOneOfMatchingRules;
import com.twitter.clientlib.model.Tweet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The values returned with a successful streamed tweet. Includes the user provided rules that the tweet matched.")
public class FilteredStreamingTweetOneOf {
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private Tweet data;
    public static final String SERIALIZED_NAME_MATCHING_RULES = "matching_rules";
    @SerializedName(value="matching_rules")
    private List<FilteredStreamingTweetOneOfMatchingRules> matchingRules = new ArrayList<FilteredStreamingTweetOneOfMatchingRules>();
    public static final String SERIALIZED_NAME_INCLUDES = "includes";
    @SerializedName(value="includes")
    private Expansions includes;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FilteredStreamingTweetOneOf data(Tweet data) {
        this.data = data;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Tweet getData() {
        return this.data;
    }

    public void setData(Tweet data) {
        this.data = data;
    }

    public FilteredStreamingTweetOneOf matchingRules(List<FilteredStreamingTweetOneOfMatchingRules> matchingRules) {
        this.matchingRules = matchingRules;
        return this;
    }

    public FilteredStreamingTweetOneOf addMatchingRulesItem(FilteredStreamingTweetOneOfMatchingRules matchingRulesItem) {
        this.matchingRules.add(matchingRulesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The list of rules which matched the tweet")
    public List<FilteredStreamingTweetOneOfMatchingRules> getMatchingRules() {
        return this.matchingRules;
    }

    public void setMatchingRules(List<FilteredStreamingTweetOneOfMatchingRules> matchingRules) {
        this.matchingRules = matchingRules;
    }

    public FilteredStreamingTweetOneOf includes(Expansions includes) {
        this.includes = includes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Expansions getIncludes() {
        return this.includes;
    }

    public void setIncludes(Expansions includes) {
        this.includes = includes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredStreamingTweetOneOf filteredStreamingTweetOneOf = (FilteredStreamingTweetOneOf)o;
        return Objects.equals(this.data, filteredStreamingTweetOneOf.data) && Objects.equals(this.matchingRules, filteredStreamingTweetOneOf.matchingRules) && Objects.equals(this.includes, filteredStreamingTweetOneOf.includes);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.matchingRules, this.includes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilteredStreamingTweetOneOf {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    matchingRules: ").append(this.toIndentedString(this.matchingRules)).append("\n");
        sb.append("    includes: ").append(this.toIndentedString(this.includes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraymatchingRules;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FilteredStreamingTweetOneOf is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FilteredStreamingTweetOneOf` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DATA) != null) {
            Tweet.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DATA));
        }
        if ((jsonArraymatchingRules = jsonObj.getAsJsonArray(SERIALIZED_NAME_MATCHING_RULES)) != null) {
            for (int i = 0; i < jsonArraymatchingRules.size(); ++i) {
                FilteredStreamingTweetOneOfMatchingRules.validateJsonObject(jsonArraymatchingRules.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INCLUDES) != null) {
            Expansions.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INCLUDES));
        }
    }

    public static FilteredStreamingTweetOneOf fromJson(String jsonString) throws IOException {
        return (FilteredStreamingTweetOneOf)JSON.getGson().fromJson(jsonString, FilteredStreamingTweetOneOf.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_MATCHING_RULES);
        openapiFields.add(SERIALIZED_NAME_INCLUDES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DATA);
        openapiRequiredFields.add(SERIALIZED_NAME_MATCHING_RULES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FilteredStreamingTweetOneOf.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FilteredStreamingTweetOneOf.class));
            return new TypeAdapter<FilteredStreamingTweetOneOf>(){

                public void write(JsonWriter out, FilteredStreamingTweetOneOf value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FilteredStreamingTweetOneOf read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FilteredStreamingTweetOneOf.validateJsonObject(jsonObj);
                    return (FilteredStreamingTweetOneOf)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

