/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Problem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@ApiModel(description="A problem that indicates that you are not allowed to see a particular field on a Tweet, User, etc.")
public class FieldUnauthorizedProblem
extends Problem {
    public static final String SERIALIZED_NAME_SECTION = "section";
    @SerializedName(value="section")
    private SectionEnum section;
    public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resource_type";
    @SerializedName(value="resource_type")
    private ResourceTypeEnum resourceType;
    public static final String SERIALIZED_NAME_FIELD = "field";
    @SerializedName(value="field")
    private String field;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FieldUnauthorizedProblem() {
        this.type = this.getClass().getSimpleName();
    }

    public FieldUnauthorizedProblem section(SectionEnum section) {
        this.section = section;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public SectionEnum getSection() {
        return this.section;
    }

    public void setSection(SectionEnum section) {
        this.section = section;
    }

    public FieldUnauthorizedProblem resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public FieldUnauthorizedProblem field(String field) {
        this.field = field;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldUnauthorizedProblem fieldUnauthorizedProblem = (FieldUnauthorizedProblem)o;
        return Objects.equals((Object)this.section, (Object)fieldUnauthorizedProblem.section) && Objects.equals((Object)this.resourceType, (Object)fieldUnauthorizedProblem.resourceType) && Objects.equals(this.field, fieldUnauthorizedProblem.field) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.section, this.resourceType, this.field, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldUnauthorizedProblem {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    section: ").append(this.toIndentedString((Object)this.section)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FieldUnauthorizedProblem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FieldUnauthorizedProblem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static FieldUnauthorizedProblem fromJson(String jsonString) throws IOException {
        return (FieldUnauthorizedProblem)JSON.getGson().fromJson(jsonString, FieldUnauthorizedProblem.class);
    }

    @Override
    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add("type");
        openapiFields.add("title");
        openapiFields.add("detail");
        openapiFields.add("status");
        openapiFields.add(SERIALIZED_NAME_SECTION);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_TYPE);
        openapiFields.add(SERIALIZED_NAME_FIELD);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SECTION);
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_FIELD);
        openapiRequiredFields.add("type");
        openapiRequiredFields.add("title");
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FieldUnauthorizedProblem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FieldUnauthorizedProblem.class));
            return new TypeAdapter<FieldUnauthorizedProblem>(){

                public void write(JsonWriter out, FieldUnauthorizedProblem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FieldUnauthorizedProblem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FieldUnauthorizedProblem.validateJsonObject(jsonObj);
                    return (FieldUnauthorizedProblem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResourceTypeEnum {
        TWEET("tweet"),
        USER("user"),
        MEDIA("media"),
        LIST("list"),
        SPACE("space");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ResourceTypeEnum> {
            public void write(JsonWriter jsonWriter, ResourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResourceTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SectionEnum {
        DATA("data"),
        INCLUDES("includes");

        private String value;

        private SectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SectionEnum fromValue(String value) {
            for (SectionEnum b : SectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SectionEnum> {
            public void write(JsonWriter jsonWriter, SectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SectionEnum.fromValue(value);
            }
        }
    }
}

