/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.CreateTweetRequestGeo;
import com.twitter.clientlib.model.CreateTweetRequestMedia;
import com.twitter.clientlib.model.CreateTweetRequestPoll;
import com.twitter.clientlib.model.CreateTweetRequestReply;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class CreateTweetRequest {
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    private String text;
    public static final String SERIALIZED_NAME_DIRECT_MESSAGE_DEEP_LINK = "direct_message_deep_link";
    @SerializedName(value="direct_message_deep_link")
    private String directMessageDeepLink;
    public static final String SERIALIZED_NAME_QUOTE_TWEET_ID = "quote_tweet_id";
    @SerializedName(value="quote_tweet_id")
    private String quoteTweetId;
    public static final String SERIALIZED_NAME_FOR_SUPER_FOLLOWERS_ONLY = "for_super_followers_only";
    @SerializedName(value="for_super_followers_only")
    private Boolean forSuperFollowersOnly;
    public static final String SERIALIZED_NAME_REPLY = "reply";
    @SerializedName(value="reply")
    private CreateTweetRequestReply reply;
    public static final String SERIALIZED_NAME_MEDIA = "media";
    @SerializedName(value="media")
    private CreateTweetRequestMedia media;
    public static final String SERIALIZED_NAME_POLL = "poll";
    @SerializedName(value="poll")
    private CreateTweetRequestPoll poll;
    public static final String SERIALIZED_NAME_REPLY_SETTINGS = "reply_settings";
    @SerializedName(value="reply_settings")
    private ReplySettingsEnum replySettings;
    public static final String SERIALIZED_NAME_GEO = "geo";
    @SerializedName(value="geo")
    private CreateTweetRequestGeo geo;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateTweetRequest text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Learn how to use the user Tweet timeline and user mention timeline endpoints in the Twitter API v2 to explore Tweet\\u2026 https://t.co/56a0vZUx7i", value="The content of the Tweet.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public CreateTweetRequest directMessageDeepLink(String directMessageDeepLink) {
        this.directMessageDeepLink = directMessageDeepLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Link to take the conversation from the public timeline to a private Direct Message.")
    public String getDirectMessageDeepLink() {
        return this.directMessageDeepLink;
    }

    public void setDirectMessageDeepLink(String directMessageDeepLink) {
        this.directMessageDeepLink = directMessageDeepLink;
    }

    public CreateTweetRequest quoteTweetId(String quoteTweetId) {
        this.quoteTweetId = quoteTweetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1346889436626259968", value="Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getQuoteTweetId() {
        return this.quoteTweetId;
    }

    public void setQuoteTweetId(String quoteTweetId) {
        this.quoteTweetId = quoteTweetId;
    }

    public CreateTweetRequest forSuperFollowersOnly(Boolean forSuperFollowersOnly) {
        this.forSuperFollowersOnly = forSuperFollowersOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Exclusive Tweet for super followers.")
    public Boolean getForSuperFollowersOnly() {
        return this.forSuperFollowersOnly;
    }

    public void setForSuperFollowersOnly(Boolean forSuperFollowersOnly) {
        this.forSuperFollowersOnly = forSuperFollowersOnly;
    }

    public CreateTweetRequest reply(CreateTweetRequestReply reply) {
        this.reply = reply;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreateTweetRequestReply getReply() {
        return this.reply;
    }

    public void setReply(CreateTweetRequestReply reply) {
        this.reply = reply;
    }

    public CreateTweetRequest media(CreateTweetRequestMedia media) {
        this.media = media;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreateTweetRequestMedia getMedia() {
        return this.media;
    }

    public void setMedia(CreateTweetRequestMedia media) {
        this.media = media;
    }

    public CreateTweetRequest poll(CreateTweetRequestPoll poll) {
        this.poll = poll;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreateTweetRequestPoll getPoll() {
        return this.poll;
    }

    public void setPoll(CreateTweetRequestPoll poll) {
        this.poll = poll;
    }

    public CreateTweetRequest replySettings(ReplySettingsEnum replySettings) {
        this.replySettings = replySettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Settings to indicate who can reply to the Tweet.")
    public ReplySettingsEnum getReplySettings() {
        return this.replySettings;
    }

    public void setReplySettings(ReplySettingsEnum replySettings) {
        this.replySettings = replySettings;
    }

    public CreateTweetRequest geo(CreateTweetRequestGeo geo) {
        this.geo = geo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreateTweetRequestGeo getGeo() {
        return this.geo;
    }

    public void setGeo(CreateTweetRequestGeo geo) {
        this.geo = geo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTweetRequest createTweetRequest = (CreateTweetRequest)o;
        return Objects.equals(this.text, createTweetRequest.text) && Objects.equals(this.directMessageDeepLink, createTweetRequest.directMessageDeepLink) && Objects.equals(this.quoteTweetId, createTweetRequest.quoteTweetId) && Objects.equals(this.forSuperFollowersOnly, createTweetRequest.forSuperFollowersOnly) && Objects.equals(this.reply, createTweetRequest.reply) && Objects.equals(this.media, createTweetRequest.media) && Objects.equals(this.poll, createTweetRequest.poll) && Objects.equals((Object)this.replySettings, (Object)createTweetRequest.replySettings) && Objects.equals(this.geo, createTweetRequest.geo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.directMessageDeepLink, this.quoteTweetId, this.forSuperFollowersOnly, this.reply, this.media, this.poll, this.replySettings, this.geo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTweetRequest {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    directMessageDeepLink: ").append(this.toIndentedString(this.directMessageDeepLink)).append("\n");
        sb.append("    quoteTweetId: ").append(this.toIndentedString(this.quoteTweetId)).append("\n");
        sb.append("    forSuperFollowersOnly: ").append(this.toIndentedString(this.forSuperFollowersOnly)).append("\n");
        sb.append("    reply: ").append(this.toIndentedString(this.reply)).append("\n");
        sb.append("    media: ").append(this.toIndentedString(this.media)).append("\n");
        sb.append("    poll: ").append(this.toIndentedString(this.poll)).append("\n");
        sb.append("    replySettings: ").append(this.toIndentedString((Object)this.replySettings)).append("\n");
        sb.append("    geo: ").append(this.toIndentedString(this.geo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateTweetRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateTweetRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_REPLY) != null) {
            CreateTweetRequestReply.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_REPLY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEDIA) != null) {
            CreateTweetRequestMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEDIA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_POLL) != null) {
            CreateTweetRequestPoll.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_POLL));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GEO) != null) {
            CreateTweetRequestGeo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GEO));
        }
    }

    public static CreateTweetRequest fromJson(String jsonString) throws IOException {
        return (CreateTweetRequest)JSON.getGson().fromJson(jsonString, CreateTweetRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TEXT);
        openapiFields.add(SERIALIZED_NAME_DIRECT_MESSAGE_DEEP_LINK);
        openapiFields.add(SERIALIZED_NAME_QUOTE_TWEET_ID);
        openapiFields.add(SERIALIZED_NAME_FOR_SUPER_FOLLOWERS_ONLY);
        openapiFields.add(SERIALIZED_NAME_REPLY);
        openapiFields.add(SERIALIZED_NAME_MEDIA);
        openapiFields.add(SERIALIZED_NAME_POLL);
        openapiFields.add(SERIALIZED_NAME_REPLY_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_GEO);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateTweetRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateTweetRequest.class));
            return new TypeAdapter<CreateTweetRequest>(){

                public void write(JsonWriter out, CreateTweetRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateTweetRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateTweetRequest.validateJsonObject(jsonObj);
                    return (CreateTweetRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReplySettingsEnum {
        FOLLOWING("following"),
        MENTIONEDUSERS("mentionedUsers");

        private String value;

        private ReplySettingsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReplySettingsEnum fromValue(String value) {
            for (ReplySettingsEnum b : ReplySettingsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReplySettingsEnum> {
            public void write(JsonWriter jsonWriter, ReplySettingsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReplySettingsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReplySettingsEnum.fromValue(value);
            }
        }
    }
}

